/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.SetChargeTarget;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinition;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Minotaur
extends ChargingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String SWING = BUILDER.add("swing", AnimationsBuilder.definition((double)1.08).marker("attack", new double[]{0.72}));
    public static final String INTERACT = BUILDER.add("interact", SWING);
    public static final String SPIN = BUILDER.add("spin", AnimationsBuilder.definition((double)1.48).marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{1.28}).marker("reset", new double[]{0.84}));
    public static final String CHARGE = BUILDER.add("charge", AnimationsBuilder.definition((double)2.64).marker("attack_start", new double[]{0.64}).marker("attack_end", new double[]{2.2}));
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<Minotaur> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private Vec3 spinDirection;
    private float spinAngle;

    public Minotaur(EntityType<? extends Minotaur> type, Level level) {
        super((EntityType<? extends ChargingMonster>)type, level);
    }

    @Override
    protected Consumer<AnimationDefinition> animatedActionConsumer() {
        return anim -> {
            super.animatedActionConsumer().accept((AnimationDefinition)anim);
            if (!this.level().isClientSide && (anim == null || anim.is(new String[]{SPIN}))) {
                this.hitEntity = null;
                this.spinDirection = null;
            }
        };
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{SWING}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(7).start(new String[]{SPIN}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{CHARGE}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(3).start(new String[]{CHARGE}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifFurtherThan(5.0)).prepare(new ExtendedBehaviour[]{new SetChargeTarget()}).end(8).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(6, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        if (anim.is(new String[]{SPIN})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.getYRot(), 0.0f, this.position());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        if (anim.is(new String[]{SPIN})) {
            double attackSize = (double)this.getBbWidth() * 1.4;
            return new AABB(-attackSize, -0.2, -attackSize, attackSize, (double)this.getBbHeight() + 0.2, attackSize);
        }
        double width = (double)this.getBbWidth() * 1.6;
        double length = (double)this.getBbWidth() * 2.1;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public DynamicDamage.Builder damageSourceAttack() {
        DynamicDamage.Builder source = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new String[]{CHARGE})) {
            source.knock(DynamicDamage.KnockBackType.BACK, 2.0f);
        } else if (this.getAnimationHandler().isCurrent(new String[]{SWING})) {
            source.withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.STUN.asHolder(), 30.0);
        }
        return source;
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{SPIN})) {
            if (this.hitEntity == null) {
                this.hitEntity = new ArrayList();
            }
            if (this.spinDirection == null) {
                this.spinDirection = EntityUtils.getTargetDirection((Mob)this, EntityAnchorArgument.Anchor.FEET, true).scale(0.1);
                this.spinAngle = this.getYRot() + 90.0f;
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                this.setDeltaMovement(this.spinDirection.x(), this.getDeltaMovement().y, this.spinDirection.z());
                float start = (float)(anim.getMarker("attack_start", 0) * 20.0);
                float end = (float)(anim.getMarker("attack_end", 0) * 20.0);
                float f = (float)anim.progress((double)start, (double)end, 1.0f, 0);
                float fNext = (float)anim.progress((double)start, (double)end, 1.0f, 1);
                float angleInc = -490.0f;
                if (anim.isAt("reset")) {
                    this.hitEntity.clear();
                }
                this.hitEntity.addAll(CombatUtils.EntityAttack.create((LivingEntity)this, CombatUtils.EntityAttack.circleTargetsFixedRange(this.spinAngle + f * angleInc, this.spinAngle + fNext * angleInc, 4.5f)).withTargetPredicate(e -> this.hitPred.test(e) && !this.hitEntity.contains(e)).executeAttack());
            }
        } else {
            if (anim.is(new String[]{SWING}) && anim.isAt("attack")) {
                S2CScreenShake.sendAround((Entity)this, 16.0, 5, 3.0f);
                this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundSource(), 1.0f, 0.9f);
            }
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<? extends Minotaur> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isChargingAnim(String anim) {
        return anim.equals(CHARGE);
    }

    @Override
    public double chargingSpeed() {
        return 0.5;
    }

    @Override
    public boolean handleChargeMovement(AnimationState anim) {
        boolean res = super.handleChargeMovement(anim);
        if (res && this.tickCount % 7 == 0) {
            this.playSound((SoundEvent)RuneCraftorySounds.ENTITY_GENERIC_HEAVY_CHARGE.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        return res;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(SPIN);
            } else {
                this.getAnimationHandler().setAnimation(SWING);
            }
        }
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

