/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.GustSpell;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomFlyingTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomHoverTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class Weagle
extends BaseMonster {
    public static final TypedResource<Vec3> SWOOP_MOTION = new TypedResource(RuneCraftory.modRes("swoop_motion"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String GALE = BUILDER.add("gale", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.28}));
    public static final String PECK = BUILDER.add("peck", AnimationsBuilder.definition((double)0.56).marker("attack", new double[]{0.2}));
    public static final String INTERACT = BUILDER.add("interact", PECK);
    public static final String SWOOP = BUILDER.add("swoop", AnimationsBuilder.definition((double)0.6).marker("swoop_start", new double[]{0.2}).marker("swoop_end", new double[]{0.48}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)2.0).infinite());
    public static final String SLEEP = BUILDER.add("sleep", AnimationsBuilder.definition((double)0.0).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    protected List<LivingEntity> hitEntity;
    private final AnimationHandler<Weagle> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        this.hitEntity = null;
        this.setSwoopMotion(null);
        return false;
    });

    public Weagle(EntityType<? extends BaseMonster> type, Level level) {
        super(type, level);
        this.moveControl = new FreeMoveControl((Mob)this, 90.0f, 50.0f, FreeMoveControl.TRUE);
        this.setNoGravity(true);
    }

    @Override
    protected PathNavigation createNavigation(Level level) {
        return new FloatingFlyNavigator((Mob)this, level);
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(SWOOP_MOTION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.FLYING_SPEED).setBaseValue(0.33);
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(32.0);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{PECK}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.ifCloserThan(4.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(3).start(new String[]{SWOOP}).play(MonsterBehaviourUtils.requireInRangePlay()).condition(MonsterBehaviourUtils.ifCloserThan(4.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(2).start(new String[]{GALE}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().minDist(2.0f).radius(4.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(2, new ExtendedBehaviour[]{new StrafeTarget().strafeDistance(7.0f)}).add(5, MonsterBehaviourUtils.ifCloserThan(15.0), new ExtendedBehaviour[]{new SetRandomFlyingTarget().flightTargetPredicate((entity, pos) -> {
            LivingEntity target;
            LivingEntity livingEntity = target = BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_TARGET) ? BrainUtils.getTargetOfEntity((LivingEntity)entity) : null;
            if (target == null) {
                target = entity.getTarget();
            }
            return target != null && target.distanceToSqr(pos) <= 121.0 && Math.abs(target.getY() - pos.y()) < 6.0;
        }), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new SetRandomHoverTarget();
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new String[]{SWOOP})) {
            return this.getSwoopMotion();
        }
        return super.directionToLookAt();
    }

    @Override
    public void travel(Vec3 vec) {
        super.handleFreeTravel(vec);
    }

    @Override
    public int animationCooldown(@Nullable String anim) {
        if (anim != null && anim.equals(GALE)) {
            int diffAdd = this.difficultyCooldown();
            return this.getRandom().nextInt(40) + 50 + diffAdd;
        }
        return super.animationCooldown(anim);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        if (anim.is(new String[]{SWOOP})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).inflate(0.2).inflate(grow), this.getYRot(), 0.0f, this.position().add(this.getDeltaMovement()));
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.5;
        double length = (double)this.getBbWidth() * 1.7;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{GALE})) {
            if (anim.isAt("attack")) {
                ((GustSpell)RuneCraftorySpells.GUST_SPELL.get()).use((LivingEntity)this);
            }
        } else if (anim.is(new String[]{SWOOP})) {
            if (this.hitEntity == null) {
                this.hitEntity = new ArrayList<LivingEntity>();
            }
            if (this.getSwoopMotion() == null) {
                this.setSwoopMotion(EntityUtils.getTargetDirection((Mob)this, EntityAnchorArgument.Anchor.FEET, true).scale(0.2).add(0.0, -0.3, 0.0));
            }
            if (anim.isPast("swoop_start") && !anim.isPast("swoop_end")) {
                this.setDeltaMovement(this.getSwoopMotion());
                this.mobAttack(anim, null, e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add((LivingEntity)e);
                        this.doHurtTarget((Entity)e);
                    }
                });
            } else {
                this.setDeltaMovement(this.getSwoopMotion().multiply(-1.0, -0.7, -1.0));
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<Weagle> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 2 ? (Spell)RuneCraftorySpells.GUST_SPELL.get() : null)) {
                return;
            }
            switch (command) {
                case 2: {
                    this.getAnimationHandler().setAnimation(GALE);
                    break;
                }
                case 1: {
                    this.getAnimationHandler().setAnimation(SWOOP);
                    break;
                }
                default: {
                    this.getAnimationHandler().setAnimation(PECK);
                }
            }
        }
    }

    protected void checkFallDamage(double dist, boolean groundLogic, BlockState state, BlockPos pos) {
    }

    public Vec3 getSwoopMotion() {
        return (Vec3)this.getDataContainer().get(SWOOP_MOTION);
    }

    public void setSwoopMotion(Vec3 swoopMotion) {
        this.getDataContainer().set(SWOOP_MOTION, (Object)swoopMotion);
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
    }

    protected void onFlap() {
        this.playSound((SoundEvent)RuneCraftorySounds.ENTITY_WEAGLE_FLAP.get(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public String getSleepAnimation() {
        return SLEEP;
    }
}

