/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.GroundShakeParticleSpawner;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.BigLeafSpell;
import io.github.flemmli97.runecraftory.common.spells.SmallLeafSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedDataContainer;
import io.github.flemmli97.tenshilib.common.entity.data.SyncedEntityData;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleContainer;
import io.github.flemmli97.tenshilib.common.particle.AdvancedParticleData;
import io.github.flemmli97.tenshilib.common.particle.data.ColorData;
import io.github.flemmli97.tenshilib.common.particle.data.MotionData;
import io.github.flemmli97.tenshilib.common.registry.TenshilibSyncableEntityDatas;
import io.github.flemmli97.tenshilib.common.utils.TypedResource;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class Raccoon
extends BossMonster {
    private static final EntityDataAccessor<Integer> CLONE_INDEX = SynchedEntityData.defineId(Raccoon.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Boolean> BERSERK = SynchedEntityData.defineId(Raccoon.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final Vec3[] CLONE_POS = new Vec3[]{new Vec3(-6.0, 0.0, 0.0), new Vec3(0.0, 0.0, -6.0), new Vec3(6.0, 0.0, 0.0), new Vec3(0.0, 0.0, 6.0)};
    public static final TypedResource<Vec3> CLONE_POSITION = new TypedResource(RuneCraftory.modRes("clone_position"));
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String DOUBLE_PUNCH = BUILDER.add("double_punch", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.4, 0.68}));
    public static final String INTERACT = BUILDER.add("interact", DOUBLE_PUNCH);
    public static final String PUNCH = BUILDER.add("punch", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.6}));
    public static final String INTERACT_BERSERK = BUILDER.add("interact_berserk", PUNCH);
    public static final String JUMP = BUILDER.add("jump", AnimationsBuilder.definition((double)1.12).marker("jump", new double[]{0.24}).infinite());
    public static final String LAND = BUILDER.add("land", AnimationsBuilder.definition((double)0.36).marker("attack", new double[]{0.12}));
    public static final String STOMP = BUILDER.add("stomp", AnimationsBuilder.definition((double)1.4).marker("attack_1", new double[]{0.6}).marker("attack_2", new double[]{1.16}));
    public static final String LEAF_SHOOT = BUILDER.add("shoot", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.56}));
    public static final String LEAF_BOOMERANG = BUILDER.add("spinning_shoot", LEAF_SHOOT);
    public static final String LEAF_SHOT_CLONE = BUILDER.add("leaf_clone", AnimationsBuilder.definition((double)1.0).animationId("shoot").marker("attack", new double[]{0.56, 0.76}));
    public static final String BARRAGE = BUILDER.add("punch_barrage", AnimationsBuilder.definition((double)3.4).marker("attack", new double[]{0.6, 0.92, 1.36}).marker("vulnerable_start", new double[]{1.64}).marker("vulnerable_end", new double[]{3.08}));
    public static final String ROAR = BUILDER.add("roar", AnimationsBuilder.definition((double)1.28).marker("roar", new double[]{0.28}));
    public static final String CLONE = BUILDER.add("clone", ROAR);
    public static final String TRANSFORM = BUILDER.add("transform", AnimationsBuilder.definition((double)1.5));
    public static final String UNTRANSFORM = BUILDER.add("untransform", AnimationsBuilder.definition((double)2.2).marker("knockback_start", new double[]{1.0}).marker("knockback_end", new double[]{1.5}));
    public static final String SPAWN = BUILDER.add("spawn", AnimationsBuilder.definition((double)2.0).marker("smoke", new double[]{0.72}));
    public static final String ANGRY = BUILDER.add("angry", AnimationsBuilder.definition((double)2.0).marker("sound", new double[]{0.28}));
    public static final String DEFEAT = BUILDER.add("defeat", AnimationsBuilder.definition((double)DEATH_DURATION, (boolean)false).infinite());
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public static final byte SPAWN_SMOKE_EVENT = 66;
    private static final ImmutableMap<String, BiConsumer<AnimationState, Raccoon>> ATTACK_HANDLER = Raccoon.createAnimationHandler(b -> {
        b.put((Object)DOUBLE_PUNCH, (anim, entity) -> {
            LivingEntity target = entity.getTarget();
            if (target != null) {
                entity.getNavigation().moveTo((Entity)target, 1.0);
            }
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, target, entity::doHurtTarget);
            }
        });
        b.put((Object)PUNCH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimationState)anim, entity.getTarget(), entity::doHurtTarget);
            }
        });
        b.put((Object)BARRAGE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                Vec3 dir;
                LivingEntity target = entity.getTarget();
                if (target != null) {
                    Vec3 targetPos = target.position();
                    dir = new Vec3(targetPos.x - entity.getX(), 0.0, targetPos.z - entity.getZ()).normalize();
                    entity.setTargetPosition(target);
                } else {
                    dir = EntityUtils.horizontalLookAngle((Entity)entity);
                }
                entity.setDeltaMovement(entity.getDeltaMovement().add(dir.scale(0.6)));
                entity.mobAttack((AnimationState)anim, entity.getTarget(), entity::doHurtTarget);
            }
        });
        b.put((Object)JUMP, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("jump")) {
                Vec3 dir;
                if (entity.getTarget() != null) {
                    dir = entity.getTarget().position().subtract(entity.position());
                    dir = (dir = new Vec3(dir.x(), 0.0, dir.z())).lengthSqr() > 400.0 ? dir.normalize().scale(2.8000000000000003) : dir.scale(0.14);
                } else {
                    dir = EntityUtils.horizontalLookAngle((Entity)entity).scale(0.75);
                }
                entity.setDeltaMovement(dir.x(), 2.2, dir.z());
            }
            if (anim.isPast("jump")) {
                entity.fallDistance = 0.0f;
                entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, -0.08, 0.0));
                entity.lookAt(EntityAnchorArgument.Anchor.EYES, entity.position().add(entity.getDeltaMovement().x(), 0.0, entity.getDeltaMovement().z()));
                if (entity.getDeltaMovement().y < -1.1) {
                    entity.setDeltaMovement(entity.getDeltaMovement().x, -1.1, entity.getDeltaMovement().z);
                }
                if (anim.done(0) && entity.onGround()) {
                    entity.getAnimationHandler().setAnimation(LAND);
                }
                if (!(!anim.isPast(6.0) || entity.getBlockStateOn().is(Blocks.AIR) && entity.getBlockStateOn().is(Blocks.AIR))) {
                    entity.getAnimationHandler().setAnimation(LAND);
                }
            }
        });
        b.put((Object)LAND, (anim, entity) -> {
            if (anim.isAt("attack")) {
                DynamicDamage.Builder source = new DynamicDamage.Builder((Entity)entity).noKnockback().element(ItemElement.EARTH).hurtResistant(5).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.STUN.asHolder(), 80.0);
                entity.mobAttack((AnimationState)anim, entity.getTarget(), e -> CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, source));
                S2CScreenShake.sendAround((Entity)entity, 24.0, 8, 3.0f);
                entity.level().addFreshEntity((Entity)new GroundShakeParticleSpawner(entity.level(), (LivingEntity)entity, 360.0, (double)entity.getBbWidth() * 1.8));
                entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), entity.getSoundSource(), 1.0f, 0.9f);
            }
        });
        b.put((Object)STOMP, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack_1") || anim.isAt("attack_2")) {
                DynamicDamage.Builder source = new DynamicDamage.Builder((Entity)entity).noKnockback().element(ItemElement.EARTH).hurtResistant(5).withChangedAttribute((Holder<Attribute>)RuneCraftoryAttributes.STUN.asHolder(), 50.0);
                entity.mobAttack((AnimationState)anim, entity.getTarget(), e -> CombatUtils.mobAttack((LivingEntity)entity, (Entity)e, source));
                S2CScreenShake.sendAround((Entity)entity, 24.0, 8, 3.0f);
                entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), entity.getSoundSource(), 1.0f, 0.9f);
            }
        });
        b.put((Object)LEAF_SHOOT, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                if (entity.isEnraged()) {
                    ((SmallLeafSpell)RuneCraftorySpells.SMALL_LEAF_SPELL_X7.get()).use((LivingEntity)entity);
                } else if (entity.isTamed() || (double)entity.random.nextFloat() < 0.6) {
                    ((SmallLeafSpell)RuneCraftorySpells.SMALL_LEAF_SPELL_X3.get()).use((LivingEntity)entity);
                } else {
                    ((SmallLeafSpell)RuneCraftorySpells.SMALL_LEAF_SPELL_X5.get()).use((LivingEntity)entity);
                }
            }
        });
        b.put((Object)LEAF_SHOT_CLONE, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                if (entity.isEnraged()) {
                    ((SmallLeafSpell)RuneCraftorySpells.SMALL_LEAF_SPELL_X7.get()).use((LivingEntity)entity);
                } else if ((double)entity.random.nextFloat() < 0.6) {
                    ((SmallLeafSpell)RuneCraftorySpells.SMALL_LEAF_SPELL_X3.get()).use((LivingEntity)entity);
                } else {
                    ((SmallLeafSpell)RuneCraftorySpells.SMALL_LEAF_SPELL_X5.get()).use((LivingEntity)entity);
                }
            }
        });
        b.put((Object)LEAF_BOOMERANG, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("attack")) {
                if (entity.isEnraged()) {
                    ((BigLeafSpell)RuneCraftorySpells.BIG_LEAF_SPELL_DOUBLE.get()).use((LivingEntity)entity);
                } else {
                    ((BigLeafSpell)RuneCraftorySpells.BIG_LEAF_SPELL.get()).use((LivingEntity)entity);
                }
            }
        });
        b.put((Object)ROAR, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt("roar")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_RACCOON_ROAR.get(), 1.0f, 1.0f + (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f);
            }
        });
        b.put((Object)CLONE, (anim, entity) -> {
            entity.getNavigation().stop();
            if (anim.isAt(0.1)) {
                entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_RACCOON_ROAR.get(), 1.0f, 1.0f + (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f);
                Vec3 center = entity.getTarget() == null ? entity.position() : (entity.distanceToSqr((Entity)entity.getTarget()) < 144.0 ? entity.getTarget().position() : entity.getTarget().position().subtract(entity.position()).normalize().scale(12.0).add(entity.position()));
                entity.setClonePos(center);
                int id = entity.random.nextInt(CLONE_POS.length);
                Vec3 pos2 = CLONE_POS[id];
                entity.entityData.set(CLONE_INDEX, (Object)id);
                entity.teleportTo(center.x() + pos2.x, center.y() + pos2.y, center.z() + pos2.z);
            }
            entity.cloneCenter().ifPresent(pos -> entity.lookAt(EntityAnchorArgument.Anchor.FEET, (Vec3)pos));
        });
        b.put((Object)UNTRANSFORM, (anim, entity) -> {
            if (entity.onGround() && anim.isPast("knockback_start") && !anim.isPast("knockback_end")) {
                entity.push(0.0, 0.4, 0.0);
            }
        });
        b.put((Object)SPAWN, (anim, entity) -> {
            if (anim.isAt("smoke")) {
                entity.level().broadcastEntityEvent((Entity)entity, (byte)66);
            }
        });
        b.put((Object)ANGRY, (anim, entity) -> {
            if (anim.isAt("sound")) {
                entity.playSound((SoundEvent)RuneCraftorySounds.ENTITY_RACCOON_ROAR.get(), 1.0f, 1.0f + (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f);
            }
        });
    });
    private final AnimationHandler<Raccoon> animationHandler = new AnimationHandler((Entity)this, ANIMS).withChangeListener(anim -> {
        if (!this.level().isClientSide) {
            if (anim == null && this.isBerserk() && this.getAnimationHandler().isCurrent(new String[]{TRANSFORM}) && this.pendingAngry) {
                this.pendingAngry = false;
                this.getAnimationHandler().setAnimation(ANGRY);
                return true;
            }
            this.setClonePos(null);
            if (anim == null && this.getAnimationHandler().isCurrent(new String[]{CLONE})) {
                this.getAnimationHandler().setAnimation(this.getRandom().nextBoolean() ? LEAF_SHOT_CLONE : LEAF_BOOMERANG);
                return true;
            }
        }
        return false;
    });
    private int hit;
    private int hitCountdown = -1;
    private final EntityDimensions berserkDimensions = EntityDimensions.scalable((float)1.4f, (float)2.5f).withAttachments(EntityAttachments.builder().attach(EntityAttachment.PASSENGER, new Vec3(0.0, 1.875, -0.4375)));
    private boolean pendingAngry;

    public Raccoon(EntityType<? extends Raccoon> type, Level level) {
        super((EntityType<? extends BossMonster>)type, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(RuneCraftoryEntities.RACCOON.getID(), this.getDisplayName(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS).setMusic((SoundEvent)RuneCraftorySounds.RACCOON_FIGHT.get());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BERSERK, (Object)false);
        builder.define(CLONE_INDEX, (Object)0);
    }

    @Override
    protected void definedAdditinoalSyncedData(SyncedDataContainer.Builder<BaseMonster> builder) {
        super.definedAdditinoalSyncedData(builder);
        builder.define(CLONE_POSITION, (SyncedEntityData)TenshilibSyncableEntityDatas.VEC_3.get(), null);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (BERSERK.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.27);
        super.applyAttributes();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(MonsterBehaviourUtils.checkedAttack(DOUBLE_PUNCH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isBerserk() && MonsterBehaviourUtils.ifCloserThan(7.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(20).start(MonsterBehaviourUtils.checkedAttack(DOUBLE_PUNCH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(m -> !m.isBerserk() && MonsterBehaviourUtils.ifCloserThan(7.0).test(m)).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.2f))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(17).start(MonsterBehaviourUtils.checkedAttack(PUNCH)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(7.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(20).start(MonsterBehaviourUtils.checkedAttack(JUMP)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(24.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(16))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(18).start(MonsterBehaviourUtils.checkedAttack(STOMP)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(7.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.timedMovement()}).end(18).start(MonsterBehaviourUtils.checkedAttack(LEAF_SHOOT)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(20.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod(1.1f).minDist(4.0f).radius(9.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(17).start(MonsterBehaviourUtils.checkedAttack(LEAF_BOOMERANG)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(20.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod(1.1f).minDist(4.0f).radius(6.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(18).start(MonsterBehaviourUtils.checkedAttack(ROAR)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(12.0))).end(3).start(MonsterBehaviourUtils.checkedAttack(BARRAGE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(7.0))).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(9))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(1).start(MonsterBehaviourUtils.checkedAttack(CLONE)).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.and(BossMonster::isEnraged, Raccoon::isBerserk, MonsterBehaviourUtils.ifCloserThan(32.0))).end(7).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(3, Raccoon::isBerserk, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(2, MonsterBehaviourUtils.withCondition(m -> !m.isBerserk() && MonsterBehaviourUtils.ifCloserThan(6.0).test(m)), new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(1.1f), MonsterBehaviourUtils.moveTo()}).add(4, m -> !m.isBerserk() && MonsterBehaviourUtils.ifFurtherThan(4.0).test(m), new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(1.1f)).closeEnoughDist(MonsterBehaviourUtils.closeEnough(3)), MonsterBehaviourUtils.moveTo()}).add(3, MonsterBehaviourUtils.withCondition(m -> !m.isBerserk() && MonsterBehaviourUtils.ifCloserThan(5.0).test(m)), new ExtendedBehaviour[]{new SetWalkTargetAwayFromTarget().speedMod(1.1f).minDist(4.0f).radius(6.0).speedMod(1.1f), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide) {
            --this.hitCountdown;
            if (this.isAlive() && !this.isBerserk() && (this.hitCountdown == 0 || this.hit >= 5)) {
                this.setBerserk(true, false);
                this.hit = 0;
            }
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            if (!this.isBerserk()) {
                this.pendingAngry = true;
            } else {
                this.getAnimationHandler().setAnimation(ANGRY);
            }
        }
    }

    public boolean isBerserk() {
        return (Boolean)this.entityData.get(BERSERK);
    }

    public void setBerserk(boolean flag, boolean load) {
        this.entityData.set(BERSERK, (Object)flag);
        this.refreshDimensions();
        if (!load) {
            if (flag) {
                this.getAnimationHandler().setAnimation(TRANSFORM);
            } else {
                this.getAnimationHandler().setAnimation(UNTRANSFORM);
            }
        }
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isBerserk()) {
            return this.berserkDimensions.scale(this.getAgeScale());
        }
        return super.getDefaultDimensions(pose);
    }

    @Override
    public float getScale() {
        if (this.isBerserk()) {
            return super.getScale() * 1.4f;
        }
        return super.getScale();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Berserk", this.isBerserk());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setBerserk(compound.getBoolean("Berserk"), true);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.getAnimationHandler().isCurrent(new String[]{JUMP, LAND, DEFEAT, TRANSFORM, UNTRANSFORM, ANGRY, SPAWN})) {
            return false;
        }
        return super.hurt(source, amount);
    }

    @Override
    protected void actuallyHurt(DamageSource source, float damageAmount) {
        AnimationState anim;
        super.actuallyHurt(source, damageAmount);
        if (!this.isBerserk()) {
            ++this.hit;
            this.hitCountdown = 30;
        } else if (this.getAnimationHandler().isCurrent(new String[]{BARRAGE}) && (anim = this.getAnimationHandler().getAnimation()).isPast("vulnerable_start") && !anim.isPast("vulnerable_end")) {
            this.setBerserk(false, false);
            this.getAnimationHandler().setAnimation(UNTRANSFORM);
            this.push(0.0, 0.6, 0.0);
        }
    }

    @Override
    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 66) {
            for (int i = 0; i < 32; ++i) {
                AdvancedParticleContainer.make((ParticleOptions)ParticleTypes.SMOKE).addData((AdvancedParticleData)new ColorData(1.0f, 1.0f, 1.0f)).addData((AdvancedParticleData)new MotionData(this.getRandom().nextGaussian() * 0.02, this.getRandom().nextGaussian() * 0.02, this.getRandom().nextGaussian() * 0.02)).add(this.level(), this.getRandomX(1.2), this.getY(this.getRandom().nextDouble() * 1.2), this.getRandomZ(1.2));
            }
        }
    }

    protected int calculateFallDamage(float fallDistance, float damageMultiplier) {
        return super.calculateFallDamage(fallDistance - 5.0f, damageMultiplier);
    }

    public void push(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new String[]{ANGRY, ROAR, DEFEAT})) {
            return;
        }
        super.push(x, y, z);
    }

    public void push(Entity entityIn) {
        if (this.getAnimationHandler().isCurrent(new String[]{ROAR, CLONE, TRANSFORM})) {
            return;
        }
        super.push(entityIn);
    }

    protected void pushEntities() {
        if (!this.getAnimationHandler().isCurrent(new String[]{CLONE})) {
            super.pushEntities();
        }
    }

    @Override
    protected boolean isImmobile() {
        return super.isImmobile() || this.getAnimationHandler().isCurrent(new String[]{CLONE, TRANSFORM, UNTRANSFORM, ROAR});
    }

    @Override
    public MoveType calculateMoveType() {
        if (this.getAnimationHandler().isCurrent(new String[]{TRANSFORM, UNTRANSFORM})) {
            return MoveType.NONE;
        }
        return super.calculateMoveType();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimationState anim, Vec3 target, double grow) {
        if (anim.is(new String[]{JUMP, LAND})) {
            return new OrientedBoundingBox(this.attackBB(anim), 0.0f, 0.0f, this.position());
        }
        if (anim.is(new String[]{STOMP})) {
            Vec3 dir;
            double reach = (double)this.getBbWidth() * 0.55;
            float offset = anim.isAt("attack_1") ? -90.0f : 90.0f;
            LivingEntity livingEntity = this.getControllingPassenger();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                dir = Vec3.directionFromRotation((float)player.getXRot(), (float)(player.getYRot() + offset));
            } else {
                dir = Vec3.directionFromRotation((float)this.getXRot(), (float)(this.getYRot() + offset));
            }
            Vec3 attackPos = this.position().add(dir.scale(reach));
            return new OrientedBoundingBox(this.attackBB(anim), this.getYRot(), 0.0f, attackPos);
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        if (anim.is(new String[]{JUMP, LAND})) {
            double attackSize = (double)this.getBbWidth() * 1.6;
            return new AABB(-attackSize, -0.5, -attackSize, attackSize, 2.0, attackSize);
        }
        if (anim.is(new String[]{STOMP})) {
            return new AABB(-1.9, -0.5, -2.3, 1.9, 2.0, 2.3);
        }
        double width = (double)this.getBbWidth() * 1.4;
        double length = (double)this.getBbWidth() * 1.5;
        if (anim.is(new String[]{DOUBLE_PUNCH})) {
            width = (double)this.getBbWidth() * 1.5;
            length = (double)this.getBbWidth() * 1.7;
        }
        if (anim.is(new String[]{PUNCH})) {
            width = (double)this.getBbWidth() * 1.5;
            length = (double)this.getBbWidth() * 1.6;
        }
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        this.getNavigation().stop();
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public AnimationHandler<Raccoon> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 2 ? (Spell)RuneCraftorySpells.SMALL_LEAF_SPELL_X3.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(LEAF_SHOOT);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(JUMP);
            } else {
                this.getAnimationHandler().setAnimation(DOUBLE_PUNCH);
            }
        }
    }

    public Optional<Vec3> cloneCenter() {
        return Optional.ofNullable((Vec3)this.getDataContainer().get(CLONE_POSITION));
    }

    public void setClonePos(Vec3 pos) {
        this.getDataContainer().set(CLONE_POSITION, (Object)pos);
    }

    public int cloneIndex() {
        return (Integer)this.entityData.get(CLONE_INDEX);
    }

    @Override
    public String getInteractAnimation() {
        return this.isBerserk() ? INTERACT_BERSERK : INTERACT;
    }

    @Override
    public String getSpawnAnimation() {
        return SPAWN;
    }

    @Override
    public String getDeathAnimation() {
        return DEFEAT;
    }
}

