/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia;

import io.github.flemmli97.runecraftory.common.entities.ai.goal.RafflesiaPartAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.Rafflesia;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class RafflesiaPart
extends Mob
implements AnimatedEntity,
OwnableEntity {
    private static final EntityDataAccessor<Optional<UUID>> PARENT = SynchedEntityData.defineId(RafflesiaPart.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Direction> SPAWN_DIRECTION = SynchedEntityData.defineId(RafflesiaPart.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String HORSE_TAIL_ACTION = BUILDER.add("horse_tail_action", AnimationsBuilder.definition((double)1.28).marker("attack", new double[]{0.56}));
    public static final String FLOWER_ACTION = BUILDER.add("flower_action", AnimationsBuilder.definition((double)1.0).marker("attack", new double[]{0.4456}));
    public static final String PITCHER_ACTION = BUILDER.add("pitcher_action", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.4}));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    public final RafflesiaPartAttackGoal attack = new RafflesiaPartAttackGoal(this);
    private Rafflesia parent;

    public RafflesiaPart(EntityType<? extends Mob> entityType, Level level, Rafflesia parent) {
        this(entityType, level);
        this.parent = parent;
        this.entityData.set(PARENT, Optional.of(this.parent.getUUID()));
        this.getAttributes().load(parent.getAttributes().save());
        double health = parent.getAttributeValue(Attributes.MAX_HEALTH) * 0.33;
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(health);
        this.setHealth(this.getMaxHealth());
    }

    public RafflesiaPart(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
        if (!level.isClientSide) {
            this.goalSelector.addGoal(1, (Goal)this.attack);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder map = Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.FOLLOW_RANGE, 32.0);
        for (RegistryEntrySupplier<Attribute, ?> att : RuneCraftoryAttributes.ENTITY_ATTRIBUTES) {
            map.add(att.asHolder());
        }
        return map;
    }

    protected PathNavigation createNavigation(Level level) {
        return new GroundPathNavigation(this, this, level){

            @Nullable
            protected Path createPath(Set<BlockPos> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                return null;
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PARENT, Optional.empty());
        builder.define(SPAWN_DIRECTION, (Object)Direction.NORTH);
    }

    public void baseTick() {
        if (!this.level().isClientSide && !this.firstTick) {
            if (this.getOwner() != null) {
                if (this.getOwner().isDeadOrDying() || this.getPartType().getPart.apply(this.getOwner()) != this) {
                    this.discard();
                } else {
                    if (this.getTarget() != this.getOwner().getTarget()) {
                        this.setTarget(this.getOwner().getTarget());
                    }
                    this.setPos(this.getOwner().position().add(Rafflesia.rotateVec((Direction)this.entityData.get(SPAWN_DIRECTION), this.offset())));
                }
            } else if (this.getOwnerUUID() == null) {
                this.discard();
            }
        }
        super.baseTick();
        this.getAnimationHandler().tick();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ((Optional)this.entityData.get(PARENT)).ifPresent(uuid -> compound.putUUID("Parent", uuid));
        compound.putInt("SpawnDirection", ((Direction)this.entityData.get(SPAWN_DIRECTION)).ordinal());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.hasUUID("Parent")) {
            this.entityData.set(PARENT, Optional.of(compound.getUUID("Parent")));
        }
        try {
            this.entityData.set(SPAWN_DIRECTION, (Object)Direction.values()[compound.getInt("SpawnDirection")]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public abstract PartType getPartType();

    public abstract Vec3 offset();

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(PARENT)).orElse(null);
    }

    @Nullable
    public Rafflesia getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            if (this.parent == null || !this.parent.isAlive()) {
                this.parent = (Rafflesia)EntityUtils.findFromUUID(Rafflesia.class, (Level)this.level(), (UUID)uuid);
            }
        } else {
            this.parent = null;
        }
        return this.parent;
    }

    public void setSpawnDirection(Direction direction) {
        this.entityData.set(SPAWN_DIRECTION, (Object)direction);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public abstract String attackAnim();

    public int cooldown() {
        return this.getRandom().nextInt(40) + 100;
    }

    public static enum PartType {
        FLOWER(Rafflesia::getFlower),
        HORSETAIL(Rafflesia::getHorseTail),
        PITCHER(Rafflesia::getPitcher);

        private final Function<Rafflesia, Entity> getPart;

        private PartType(Function<Rafflesia, Entity> getPart) {
            this.getPart = getPart;
        }
    }
}

