/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.utils;

import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import java.util.function.Supplier;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class MoveStateTracker {
    private final LivingEntity entity;
    private final int transitionTime;
    private final EntityDataAccessor<Byte> moveFlagData;
    private final Supplier<MoveType> calculateState;
    private final int[] states = new int[MoveType.values().length];
    private int genericMoveTick;

    public MoveStateTracker(LivingEntity entity, int transitionTime, EntityDataAccessor<Byte> moveFlagData, Supplier<MoveType> calculateState) {
        this.entity = entity;
        this.transitionTime = transitionTime;
        this.moveFlagData = moveFlagData;
        this.calculateState = calculateState;
    }

    private MoveType getCurrent() {
        return MoveType.values()[(Byte)this.entity.getEntityData().get(this.moveFlagData)];
    }

    public void tick() {
        if (!this.entity.level().isClientSide) {
            MoveType moveType = this.calculateState.get();
            switch (moveType) {
                case NONE: {
                    this.entity.setShiftKeyDown(false);
                    this.entity.setSprinting(false);
                    break;
                }
                case SNEAK: {
                    this.entity.setShiftKeyDown(false);
                    break;
                }
                case RUN: {
                    this.entity.setSprinting(false);
                }
            }
            this.entity.getEntityData().set(this.moveFlagData, (Object)((byte)moveType.ordinal()));
        }
        MoveType current = this.getCurrent();
        for (int i = 0; i < this.states.length; ++i) {
            if (i == current.ordinal()) {
                int n = i;
                int n2 = this.states[n] + 1;
                this.states[n] = n2;
                this.states[i] = Math.min(this.transitionTime, n2);
                continue;
            }
            int n = i;
            int n3 = this.states[n] - 1;
            this.states[n] = n3;
            this.states[i] = Math.max(-1, n3);
        }
        this.genericMoveTick = current != MoveType.NONE ? Math.min(this.transitionTime, ++this.genericMoveTick) : Math.max(-1, --this.genericMoveTick);
    }

    public float interpolatedMoveTick(float partialTicks) {
        if (this.genericMoveTick == -1) {
            return 0.0f;
        }
        float speedMod = Mth.clamp((float)(this.entity.walkAnimation.speed(partialTicks) / 0.25f), (float)0.0f, (float)1.0f);
        MoveType current = this.getCurrent();
        return Mth.clamp((float)(((float)this.genericMoveTick + (current != MoveType.NONE ? partialTicks : -partialTicks)) / (float)this.transitionTime), (float)0.0f, (float)1.0f) * speedMod;
    }

    public float interpolatedMoveTickOf(MoveType moveType, float partialTicks) {
        int tick = this.states[moveType.ordinal()];
        if (tick == -1) {
            return 0.0f;
        }
        float speedMod = moveType.speedDependent ? Mth.clamp((float)(this.entity.walkAnimation.speed(partialTicks) / 0.25f), (float)0.0f, (float)1.0f) : 1.0f;
        MoveType current = this.getCurrent();
        return Mth.clamp((float)(((float)tick + (current == moveType ? partialTicks : -partialTicks)) / (float)this.transitionTime), (float)0.0f, (float)1.0f) * speedMod;
    }
}

