/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.fluid;

import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryFluids;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;

public abstract class HotSpringFluid
extends WaterFluid {
    public void animateTick(Level level, BlockPos pos, FluidState state, RandomSource random) {
        BlockState above;
        if (!state.isSource() && !((Boolean)state.getValue((Property)FALLING)).booleanValue() && random.nextInt(64) == 0) {
            level.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
        }
        if (random.nextInt(20) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.END_ROD, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble() * 1.2, (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
        if (random.nextInt(48) == 0 && (above = level.getBlockState(pos.above())).getFluidState().isEmpty() && above.getCollisionShape((BlockGetter)level, pos.above()).isEmpty()) {
            level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + 0.3 + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.0, 0.07, 0.0);
        }
    }

    public Fluid getFlowing() {
        return (Fluid)RuneCraftoryFluids.FLOWING_HOT_SPRING_WATER.get();
    }

    public Fluid getSource() {
        return (Fluid)RuneCraftoryFluids.HOT_SPRING_WATER.get();
    }

    public Item getBucket() {
        return (Item)RuneCraftoryItems.HOT_SPRING_BUCKET.get();
    }

    protected boolean canConvertToSource(Level level) {
        return GeneralConfig.hotSpringSource;
    }

    public BlockState createLegacyBlock(FluidState state) {
        return (BlockState)((LiquidBlock)RuneCraftoryBlocks.HOT_SPRING_WATER.get()).defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(HotSpringFluid.getLegacyLevel((FluidState)state)));
    }

    public boolean isSame(Fluid fluid) {
        return fluid == this.getSource() || fluid == this.getFlowing();
    }

    public static class Source
    extends HotSpringFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends HotSpringFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

