/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.tools;

import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemStatIncrease
extends Item {
    private final Stat stat;

    public ItemStatIncrease(Stat stat, Item.Properties properties) {
        super(properties);
        this.stat = stat;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        player.startUsingItem(usedHand);
        return InteractionResultHolder.consume((Object)player.getItemInHand(usedHand));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entityLiving) {
        boolean shrink = true;
        if (entityLiving instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entityLiving;
            level.playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), (SoundEvent)RuneCraftorySounds.GENERIC_ITEM_STAT_CONSUME.get(), SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            this.increaseStat((Player)serverPlayer);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
            if (serverPlayer.isCreative()) {
                shrink = false;
            }
        }
        if (shrink) {
            stack.shrink(1);
        }
        return stack;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 32;
    }

    private void increaseStat(Player player) {
        PlayerData data = Platform.INSTANCE.getPlayerData(player);
        switch (this.stat.ordinal()) {
            case 0: {
                data.addXp((float)LevelCalc.xpAmountForLevelUp(data.getPlayerLevel().getLevel()) - data.getPlayerLevel().getXp());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                data.increaseStatBonus(this.stat);
            }
        }
    }

    public static enum Stat {
        LEVEL,
        HP,
        STR,
        INT,
        VIT;

    }
}

