/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.items.weapons;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemSpell
extends Item {
    private final Supplier<? extends Spell> spell;

    public ItemSpell(Supplier<? extends Spell> spell, Item.Properties properties) {
        super(properties);
        this.spell = spell;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, list, tooltipFlag);
        if (this.spell.get() == RuneCraftorySpells.EMPTY.get()) {
            list.add((Component)Component.literal((String)"WIP").withStyle(ChatFormatting.DARK_RED));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer && this.useSpell(serverPlayer = (ServerPlayer)player, player.getItemInHand(hand))) {
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
    }

    public boolean useSpell(ServerPlayer player, ItemStack stack) {
        if (!this.getSpell().canUse(player.serverLevel(), (LivingEntity)player, stack)) {
            return false;
        }
        if (this.getSpell().useAction() != null) {
            PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
            if (player.getCooldowns().getCooldownPercent((Item)this, 0.0f) <= 0.0f) {
                return data.getWeaponHandler().doWeaponAttack(this.getSpell().useAction(), stack, this.getSpell());
            }
            return false;
        }
        if (player.getCooldowns().getCooldownPercent((Item)this, 0.0f) <= 0.0f && this.spell.get().use(player.serverLevel(), (LivingEntity)player, stack)) {
            player.getCooldowns().addCooldown((Item)this, this.getSpell().properties().cooldown());
            this.spell.get().levelSkill(player);
            return true;
        }
        return false;
    }

    public Spell getSpell() {
        return this.spell.get();
    }
}

