/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.MapCodec;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryLootRegistries;
import java.util.Set;
import java.util.UUID;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record FriendPointCondition(int points) implements LootItemCondition
{
    public static final MapCodec<FriendPointCondition> CODEC = ExtraCodecs.NON_NEGATIVE_INT.fieldOf("points").xmap(FriendPointCondition::new, FriendPointCondition::points);

    public static LootItemCondition.Builder of(int points) {
        return () -> new FriendPointCondition(points);
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)RuneCraftoryLootRegistries.FRIENDPOINTS.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.THIS_ENTITY);
    }

    public boolean test(LootContext ctx) {
        Object object = ctx.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (object instanceof IBaseMob) {
            IBaseMob mob = (IBaseMob)object;
            UUID uuid = (UUID)ctx.getParamOrNull(LootCtxParameters.UUID_CONTEXT);
            if (uuid != null) {
                return mob.friendPoints(uuid) >= this.points;
            }
        }
        return false;
    }
}

