/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryLootRegistries;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandData;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class ItemLevelLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<ItemLevelLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> ItemLevelLootFunction.commonFields((RecordCodecBuilder.Instance)instance).and((App)NumberProviders.CODEC.fieldOf("level").forGetter(d -> d.level)).apply((Applicative)instance, ItemLevelLootFunction::new));
    private final NumberProvider level;

    private ItemLevelLootFunction(List<LootItemCondition> conditions, NumberProvider level) {
        super(conditions);
        this.level = level;
    }

    public static Builder defaultFunc() {
        return new Builder().with((NumberProvider)ConstantValue.exactly((float)1.0f));
    }

    public static Builder with(NumberProvider provider) {
        return new Builder().with(provider);
    }

    public LootItemFunctionType<ItemLevelLootFunction> getType() {
        return (LootItemFunctionType)RuneCraftoryLootRegistries.ITEM_LEVEL.get();
    }

    protected ItemStack run(ItemStack stack, LootContext ctx) {
        int level = 0;
        if (ctx.hasParam(LootCtxParameters.ITEM_LEVEL_CONTEXT)) {
            level = (Integer)ctx.getParam(LootCtxParameters.ITEM_LEVEL_CONTEXT);
        } else if (ctx.hasParam(LootContextParams.BLOCK_STATE) && ctx.hasParam(LootContextParams.ORIGIN)) {
            BlockPos blockPos = BlockPos.containing((Position)((Position)ctx.getParam(LootContextParams.ORIGIN)));
            level = FarmlandHandler.get(ctx.getLevel().getServer()).getData(ctx.getLevel(), blockPos).map(FarmlandData::getCropLevel).orElse(0);
        }
        if (level == 0) {
            level = this.getLevel(ctx);
        }
        return ItemComponentUtils.getLeveledItem(stack, Math.abs(level));
    }

    public int getLevel(LootContext ctx) {
        return this.level.getInt(ctx);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private NumberProvider level = ConstantValue.exactly((float)1.0f);

        protected Builder getThis() {
            return this;
        }

        public Builder with(NumberProvider level) {
            this.level = level;
            return this;
        }

        public LootItemFunction build() {
            return new ItemLevelLootFunction(this.getConditions(), this.level);
        }
    }
}

