/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryLootRegistries;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootingAndLuckLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<LootingAndLuckLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> LootingAndLuckLootFunction.commonFields((RecordCodecBuilder.Instance)instance).and(instance.group((App)NumberProviders.CODEC.fieldOf("base").forGetter(d -> d.baseChance), (App)Enchantment.CODEC.fieldOf("enchantment").forGetter(d -> d.enchantment), (App)NumberProviders.CODEC.fieldOf("enchanted_bonus").forGetter(d -> d.enchantedBonus), (App)NumberProviders.CODEC.fieldOf("luck_bonus").forGetter(d -> d.luckBonus), (App)Codec.INT.fieldOf("limit").forGetter(d -> d.limit))).apply((Applicative)instance, LootingAndLuckLootFunction::new));
    private final NumberProvider baseChance;
    private final Holder<Enchantment> enchantment;
    private final NumberProvider enchantedBonus;
    private final NumberProvider luckBonus;
    private final int limit;

    private LootingAndLuckLootFunction(List<LootItemCondition> conditions, NumberProvider baseChance, Holder<Enchantment> enchantment, NumberProvider enchantedBonus, NumberProvider luckBonus, int limit) {
        super(conditions);
        this.baseChance = baseChance;
        this.enchantment = enchantment;
        this.luckBonus = luckBonus;
        this.enchantedBonus = enchantedBonus;
        this.limit = limit;
    }

    public LootItemFunctionType<LootingAndLuckLootFunction> getType() {
        return (LootItemFunctionType)RuneCraftoryLootRegistries.LUCK_AND_LOOTING.get();
    }

    protected ItemStack run(ItemStack stack, LootContext ctx) {
        Entity entity = (Entity)ctx.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        float luck = ctx.getLuck();
        int looting = 0;
        List<LivingEntity> contributing = LootingAndLuckLootFunction.getContributingEntities(ctx);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            looting = EnchantmentHelper.getEnchantmentLevel(this.enchantment, (LivingEntity)living);
        }
        for (LivingEntity other : contributing) {
            looting += EnchantmentHelper.getEnchantmentLevel(this.enchantment, (LivingEntity)other);
            if (!other.getAttributes().hasAttribute(Attributes.LUCK)) continue;
            luck += (float)other.getAttributeValue(Attributes.LUCK);
        }
        float chance = (this.baseChance.getFloat(ctx) + this.luckBonus.getFloat(ctx) * luck) * (1.0f + this.enchantedBonus.getFloat(ctx) * (float)looting);
        if (chance >= 1.0f) {
            int uniform = (int)chance * 2;
            float left = chance - (float)uniform;
            int amount = ctx.getRandom().nextInt(uniform + 1);
            if (ctx.getRandom().nextFloat() < left) {
                ++amount;
            }
            if (this.limit > 0) {
                amount = Math.min(this.limit, amount);
            }
            stack.setCount(amount);
            return stack;
        }
        if (ctx.getRandom().nextFloat() < chance) {
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static List<LivingEntity> getContributingEntities(LootContext ctx) {
        NPCEntity npc;
        Entity entity = (Entity)ctx.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            PlayerData data = Platform.INSTANCE.getPlayerData(player);
            return entity.level().getEntities(EntityTypeTest.forClass(LivingEntity.class), entity.getBoundingBox().inflate(64.0), data.party::isPartyMember);
        }
        if (entity instanceof BaseMonster) {
            BaseMonster monster = (BaseMonster)entity;
            if (monster.getOwner() != null && Platform.INSTANCE.getPlayerData((Player)monster.getOwner()).party.isPartyMember((Entity)monster)) {
                return List.of(monster);
            }
        } else if (entity instanceof NPCEntity && (npc = (NPCEntity)entity).followEntity() != null && Platform.INSTANCE.getPlayerData((Player)npc.followEntity()).party.isPartyMember((Entity)npc)) {
            return List.of(npc);
        }
        return List.of();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final NumberProvider baseChance;
        private Holder<Enchantment> enchantment;
        private NumberProvider enchantedBonus = ConstantValue.exactly((float)0.0f);
        private NumberProvider luckBonus = ConstantValue.exactly((float)0.0f);
        private int limit = 0;

        public Builder(NumberProvider baseChance) {
            this.baseChance = baseChance;
        }

        protected Builder getThis() {
            return this;
        }

        public Builder withLuckBonus(NumberProvider luckBonus) {
            this.luckBonus = luckBonus;
            return this;
        }

        public Builder withLootingBonus(HolderLookup.Provider registries, NumberProvider lootingBonus) {
            this.enchantment = registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.LOOTING);
            this.enchantedBonus = lootingBonus;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public LootItemFunction build() {
            return new LootingAndLuckLootFunction(this.getConditions(), this.baseChance, this.enchantment, this.enchantedBonus, this.luckBonus, this.limit);
        }
    }
}

