/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryLootRegistries;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.Set;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class SkillLevelCondition
implements LootItemCondition {
    public static final MapCodec<SkillLevelCondition> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)CodecUtils.stringEnumCodec(Skills.class, null).fieldOf("skill").forGetter(d -> d.skill), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("minimum_level").forGetter(d -> d.min)).apply((Applicative)inst, SkillLevelCondition::new));
    private final Skills skill;
    private final int min;

    public SkillLevelCondition(Skills skills, int required) {
        this.skill = skills;
        this.min = required;
    }

    public static LootItemCondition.Builder get(Skills skill, int val) {
        return () -> new SkillLevelCondition(skill, val);
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)RuneCraftoryLootRegistries.SKILL_CHECK.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return ImmutableSet.of((Object)LootContextParams.THIS_ENTITY);
    }

    public boolean test(LootContext ctx) {
        Object object = ctx.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (object instanceof Player) {
            Player player = (Player)object;
            return Platform.INSTANCE.getPlayerData(player).getSkillLevel(this.skill).getLevel() >= this.min;
        }
        return false;
    }
}

