/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerInfoScreen;
import io.github.flemmli97.runecraftory.common.network.S2CCapSync;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public record C2SOpenInfo(Action action) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<C2SOpenInfo> TYPE = new CustomPacketPayload.Type(RuneCraftory.modRes("c2s_open_info"));
    public static final StreamCodec<RegistryFriendlyByteBuf, C2SOpenInfo> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, C2SOpenInfo>(){

        public C2SOpenInfo decode(RegistryFriendlyByteBuf buf) {
            return new C2SOpenInfo((Action)buf.readEnum(Action.class));
        }

        public void encode(RegistryFriendlyByteBuf buf, C2SOpenInfo pkt) {
            buf.writeEnum((Enum)pkt.action);
        }
    };

    public static void handle(C2SOpenInfo pkt, ServerPlayer sender) {
        switch (pkt.action.ordinal()) {
            case 0: {
                ItemStack stack = sender.containerMenu.getCarried();
                sender.containerMenu.setCarried(ItemStack.EMPTY);
                LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CCapSync(Platform.INSTANCE.getPlayerData((Player)sender)), sender);
                Platform.INSTANCE.openGuiMenu(sender, ContainerInfoScreen.create());
                if (stack.isEmpty()) break;
                sender.containerMenu.setCarried(stack);
                break;
            }
            case 1: {
                LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CCapSync(Platform.INSTANCE.getPlayerData((Player)sender)), sender);
                Platform.INSTANCE.openGuiMenu(sender, ContainerInfoScreen.createSub());
                break;
            }
            case 2: {
                ItemStack stack = sender.containerMenu.getCarried();
                sender.containerMenu.setCarried(ItemStack.EMPTY);
                sender.doCloseContainer();
                if (stack.isEmpty()) break;
                sender.containerMenu.setCarried(stack);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static enum Action {
        MAIN,
        SUB,
        INV;

    }
}

