/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerCrafting;
import java.util.ArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class S2CCraftingRecipes
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<S2CCraftingRecipes> TYPE = new CustomPacketPayload.Type(RuneCraftory.modRes("s2c_crafting_recipes_container"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CCraftingRecipes> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, S2CCraftingRecipes>(){

        public S2CCraftingRecipes decode(RegistryFriendlyByteBuf buf) {
            long lastChange = buf.readLong();
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                list.add((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf));
            }
            return new S2CCraftingRecipes(new ContainerCrafting.ClientRecipeResult(lastChange, list), buf.readInt());
        }

        public void encode(RegistryFriendlyByteBuf buf, S2CCraftingRecipes pkt) {
            buf.writeLong(pkt.data.lastChange());
            buf.writeInt(pkt.data.result().size());
            pkt.data.result().forEach(stack -> ItemStack.STREAM_CODEC.encode((Object)buf, stack));
            buf.writeInt(pkt.clientRecipeIndex);
        }
    };
    private final ContainerCrafting.ClientRecipeResult data;
    private final int clientRecipeIndex;

    public S2CCraftingRecipes(ContainerCrafting.ClientRecipeResult data, int clientRecipeIndex) {
        this.data = data;
        this.clientRecipeIndex = clientRecipeIndex;
    }

    public static void handle(S2CCraftingRecipes pkt, Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ContainerCrafting) {
            ContainerCrafting crafting = (ContainerCrafting)abstractContainerMenu;
            crafting.setMatchingRecipesClient(pkt.data);
        }
        ClientHandlers.updateCurrentRecipeIndex(pkt.clientRecipeIndex);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

