/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.network;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.config.ServerValue;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class S2CSyncConfig
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<S2CSyncConfig> TYPE = new CustomPacketPayload.Type(RuneCraftory.modRes("s2c_sync_config_values"));
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CSyncConfig> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, S2CSyncConfig>(){

        public S2CSyncConfig decode(RegistryFriendlyByteBuf buf) {
            S2CSyncConfig pkt = new S2CSyncConfig();
            pkt.buf = new FriendlyByteBuf(buf.copy());
            buf.clear();
            return pkt;
        }

        public void encode(RegistryFriendlyByteBuf buf, S2CSyncConfig pkt) {
            Map<String, ServerValue<?>> configs = ServerValue.getSyncableValues();
            buf.writeInt(configs.size());
            configs.forEach((key, val) -> {
                buf.writeUtf(key);
                val.writeToBuffer((FriendlyByteBuf)buf);
            });
        }
    };
    private FriendlyByteBuf buf;

    public static void handle(S2CSyncConfig pkt) {
        int size = pkt.buf.readInt();
        Map<String, ServerValue<?>> configs = ServerValue.getSyncableValues();
        for (int i = 0; i < size; ++i) {
            ServerValue<?> val = configs.get(pkt.buf.readUtf());
            if (val == null) continue;
            val.readFromBuffer(pkt.buf);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

