/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests;

import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public record ClientSideQuestDisplay(ResourceLocation id, Component task, List<? extends Component> description, @Nullable NPCFeatureContainer features, @Nullable String npcSkin, boolean active) {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientSideQuestDisplay> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ClientSideQuestDisplay>(){

        public ClientSideQuestDisplay decode(RegistryFriendlyByteBuf buf) {
            return new ClientSideQuestDisplay(buf.readResourceLocation(), (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf), buf.readList(b -> (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf)), buf.readBoolean() ? new NPCFeatureContainer().fromBuffer(buf) : null, buf.readBoolean() ? buf.readUtf() : null, buf.readBoolean());
        }

        public void encode(RegistryFriendlyByteBuf buf, ClientSideQuestDisplay data) {
            buf.writeResourceLocation(data.id);
            ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)data.task);
            buf.writeCollection(data.description, (b, val) -> ComponentSerialization.STREAM_CODEC.encode((Object)buf, val));
            buf.writeBoolean(data.features != null);
            if (data.features != null) {
                data.features.toBuffer(buf);
            }
            buf.writeBoolean(data.npcSkin != null);
            if (data.npcSkin != null) {
                buf.writeUtf(data.npcSkin);
            }
            buf.writeBoolean(data.active);
        }
    };
}

