/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.misc.TreasureChestEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import io.github.flemmli97.simplequests_api.datapack.QuestsManager;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.QuestCategory;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import io.github.flemmli97.simplequests_api.registry.QuestBaseRegistry;
import io.github.flemmli97.tenshilib.common.entity.EntityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class NPCQuest
extends QuestBase {
    public static final ResourceLocation ID = RuneCraftory.modRes("npc_quest");
    public static final Function<QuestBaseRegistry.CodecContext, MapCodec<NPCQuest>> CODEC = Util.memoize(ctx -> QuestBase.buildCodec((RecordCodecBuilder)NPCQuestData.CODEC.forGetter(q -> new NPCQuestData(q.npcDataIDs, q.quests, q.loot.location(), q.global, q.dynamicData)), (QuestBaseRegistry.CodecContext)ctx, (id, task, data) -> {
        Builder builder = new Builder(id, task, data.npcIDs, data.loot);
        if (data.global) {
            builder.global();
        }
        builder.withQuests(data.quests);
        if (data.dynamic != null) {
            builder.withData(data.dynamic());
        }
        return builder;
    }));
    private NPCEntity npc;
    private DynamicQuestData dynamicData;
    public final List<ResourceLocation> npcDataIDs;
    public final List<ResourceLocation> quests;
    public final ResourceKey<LootTable> loot;
    public final boolean global;

    private NPCQuest(ResourceLocation id, QuestCategory category, String questTaskString, List<String> questTaskDesc, List<ResourceLocation> parents, boolean redoParent, int repeatDelay, int maxRepeat, int sortingId, EntityPredicate unlockCondition, List<ResourceLocation> npcDataIDs, List<ResourceLocation> quests, ResourceLocation loot, boolean global) {
        super(id, category, questTaskString, questTaskDesc, parents, redoParent, false, ItemStack.EMPTY, repeatDelay, 0, maxRepeat, sortingId, false, unlockCondition, QuestBase.Visibility.NEVER);
        this.npcDataIDs = npcDataIDs;
        this.quests = quests;
        this.loot = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)loot);
        this.global = global;
    }

    private static ResourceLocation withUuid(ResourceLocation original, UUID uuid) {
        if (uuid == null) {
            return original;
        }
        return ResourceLocation.fromNamespaceAndPath((String)original.getNamespace(), (String)(original.getPath() + "/" + String.valueOf(uuid)));
    }

    private static AABB aabbOf(Vec3 pos) {
        return new AABB(pos.add(-48.0, -48.0, -48.0), pos.add(48.0, 48.0, 48.0));
    }

    public static List<NPCQuest> resolve(NPCQuest quest, ServerPlayer player, Vec3 at) {
        return player.level().getEntities(EntityTypeTest.forClass(NPCEntity.class), NPCQuest.aabbOf(at), e -> {
            if (quest.npcDataIDs.contains(e.getDataID()) && e.canAcceptNPCQuest(player, quest)) {
                ResourceLocation id = QuestHandler.questForExists(player, e);
                return id == null || quest.getOriginID().equals((Object)id);
            }
            return false;
        }).stream().map(quest::forNPC).toList();
    }

    private NPCQuest forNPC(NPCEntity npc) {
        ResourceLocation newID = NPCQuest.withUuid(this.id, npc.getUUID());
        NPCQuest quest = new NPCQuest(newID, this.category, this.name, this.description, this.neededParentQuests, this.redoParent, this.repeatDelay, this.maxRepeat, this.sortingId, this.unlockCondition, this.npcDataIDs, this.quests, this.loot.location(), this.global);
        quest.withNPC(npc, this.id);
        return quest;
    }

    private void withNPC(NPCEntity npc, ResourceLocation originID) {
        this.npc = npc;
        this.withNPC(npc.getUUID(), originID);
    }

    private void withNPC(UUID npc, ResourceLocation originID) {
        this.dynamicData = new DynamicQuestData(npc, originID);
    }

    public ResourceLocation getTypeId() {
        return ID;
    }

    public boolean isUnlocked(ServerPlayer player) {
        return super.isUnlocked(player) && (this.getNpc(player.level()) == null || this.getNpc(player.level()).canAcceptNPCQuest(player, this));
    }

    public MutableComponent getName(ServerPlayer player, int idx) {
        return Component.translatable((String)this.name);
    }

    public List<MutableComponent> getDescription(ServerPlayer player, int idx) {
        NPCEntity npc = this.getNpc(player.level());
        if (npc != null) {
            return this.description.stream().map(s -> Component.translatable((String)s, (Object[])new Object[]{npc.getCustomName(), npc.getX(), npc.getY(), npc.getZ()})).collect(Collectors.toList());
        }
        return super.getDescription(player, idx);
    }

    public UUID getNpcUuid() {
        return this.dynamicData != null ? this.dynamicData.npcUuid() : null;
    }

    @Nullable
    public NPCEntity getNpc(Level level) {
        if (this.dynamicData != null && this.npc == null) {
            this.npc = (NPCEntity)EntityUtils.findFromUUID(NPCEntity.class, (Level)level, (UUID)this.dynamicData.npcUuid());
        }
        return this.npc;
    }

    public ResourceLocation getOriginID() {
        return this.dynamicData != null ? this.dynamicData.origin() : this.id;
    }

    public String submissionTrigger(ServerPlayer player, int idx) {
        if (this.dynamicData == null) {
            return super.submissionTrigger(player, idx);
        }
        return this.dynamicData.npcUuid().toString();
    }

    public QuestBase resolveToQuest(ServerPlayer player, int idx) {
        if (idx < 0 || idx >= this.quests.size()) {
            return null;
        }
        ResourceLocation id = this.quests.get(idx);
        QuestBase quest = QuestsManager.instance().getQuest(id);
        if (quest == null) {
            return null;
        }
        return quest.resolveToQuest(player, 0);
    }

    public ResourceKey<LootTable> getLoot() {
        return this.loot;
    }

    public void onComplete(ServerPlayer serverPlayer) {
        TreasureChestEntity chest = (TreasureChestEntity)((EntityType)RuneCraftoryEntities.TREASURE_CHEST.get()).create((Level)serverPlayer.serverLevel());
        if (chest != null && this.getLoot() != null && !this.getLoot().equals((Object)BuiltInLootTables.EMPTY)) {
            chest.absMoveTo(serverPlayer.getX(2.0), serverPlayer.getY(1.5), serverPlayer.getZ(2.0), serverPlayer.getRandom().nextFloat() * 360.0f, 0.0f);
            for (int tries = 0; !serverPlayer.level().noCollision((Entity)chest) && tries < 10; ++tries) {
                chest.absMoveTo(serverPlayer.getX(2.0), serverPlayer.getY(1.5), serverPlayer.getZ(2.0), serverPlayer.getRandom().nextFloat() * 360.0f, 0.0f);
            }
            chest.setChestLoot(this.loot);
            serverPlayer.serverLevel().addFreshEntity((Entity)chest);
        }
        if (this.getNpc(serverPlayer.level()) != null) {
            this.getNpc(serverPlayer.level()).completeNPCQuest(serverPlayer, this);
        }
        this.onReset(serverPlayer);
    }

    public void onReset(ServerPlayer player) {
        if (this.dynamicData != null) {
            NPCEntity npc = this.getNpc(player.level());
            if (npc != null) {
                npc.resetQuestProcess(player, this.dynamicData.origin());
            } else {
                RunecraftorySavedData.get((MinecraftServer)player.getServer()).npcHandler.scheduleQuestTrackerReset(this.dynamicData.npcUuid(), player.getUUID(), this.dynamicData.origin());
            }
        }
    }

    public Map<String, ResolvedQuestTask> resolveTasks(PlayerQuestData data, QuestProgress progress, int idx) {
        QuestBase base = this.resolveToQuest(data.getPlayer(), idx);
        if (base == null) {
            return Map.of();
        }
        return base.resolveTasks(data, progress, 0);
    }

    public boolean isDynamic() {
        return this.dynamicData != null;
    }

    private record DynamicQuestData(UUID npcUuid, ResourceLocation origin) {
        static final Codec<DynamicQuestData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.xmap(UUID::fromString, UUID::toString).fieldOf("npcUuid").forGetter(d -> d.npcUuid), (App)ResourceLocation.CODEC.fieldOf("origin_id").forGetter(d -> d.origin)).apply((Applicative)inst, DynamicQuestData::new));
    }

    private record NPCQuestData(List<ResourceLocation> npcIDs, List<ResourceLocation> quests, ResourceLocation loot, boolean global, DynamicQuestData dynamic) {
        static final MapCodec<NPCQuestData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("global").forGetter(d -> d.global ? Optional.of(true) : Optional.empty()), (App)DynamicQuestData.CODEC.optionalFieldOf("dynamic_data").forGetter(d -> Optional.ofNullable(d.dynamic)), (App)ResourceLocation.CODEC.listOf().fieldOf("target_npc_ids").forGetter(d -> d.npcIDs), (App)ResourceLocation.CODEC.listOf().fieldOf("quests").forGetter(d -> d.quests), (App)ResourceLocation.CODEC.fieldOf("loot_table").forGetter(d -> d.loot)).apply((Applicative)inst, (global, dynamic, target, quests, loot) -> new NPCQuestData((List<ResourceLocation>)target, (List<ResourceLocation>)quests, (ResourceLocation)loot, global.orElse(false), dynamic.orElse(null))));
    }

    public static class Builder
    extends QuestBase.BuilderBase<NPCQuest, Builder> {
        private final List<ResourceLocation> npcDataID;
        private final List<ResourceLocation> quests = new ArrayList<ResourceLocation>();
        private final ResourceLocation loot;
        private boolean global;
        private DynamicQuestData dynamic;

        public Builder(ResourceLocation id, String task, ResourceLocation npcDataID, ResourceLocation loot) {
            this(id, task, List.of(npcDataID), loot);
        }

        public Builder(ResourceLocation id, String task, List<ResourceLocation> npcDataID, ResourceLocation loot) {
            super(id, task);
            this.npcDataID = npcDataID;
            this.loot = loot;
        }

        public Builder withQuests(ResourceLocation ... quest) {
            this.quests.addAll(List.of(quest));
            return this;
        }

        public Builder withQuests(Collection<ResourceLocation> quest) {
            this.quests.addAll(quest);
            return this;
        }

        public Builder global() {
            this.global = true;
            return this;
        }

        private Builder withData(DynamicQuestData dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public ResourceLocation getID() {
            return this.id;
        }

        protected Builder asThis() {
            return this;
        }

        public NPCQuest build() {
            if (this.quests.isEmpty()) {
                throw new IllegalStateException("Quests not defined");
            }
            NPCQuest quest = new NPCQuest(this.id, this.category, this.name, this.description, this.neededParentQuests, this.redoParent, this.repeatDelay, this.maxRepeat, this.sortingId, this.unlockCondition, this.npcDataID, this.quests, this.loot, this.global);
            if (this.dynamic != null) {
                quest.withNPC(this.dynamic.npcUuid(), this.dynamic.origin());
            }
            return quest;
        }
    }
}

