/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCrafting;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public class LevelUpUpgradeRecipe
implements Recipe<SingleRecipeInput> {
    protected final int level;
    protected final Ingredient base;
    protected final Ingredient upgradeMaterial;

    public LevelUpUpgradeRecipe(int level, Ingredient base, Ingredient upgradeMaterial) {
        this.level = level;
        this.base = base;
        this.upgradeMaterial = upgradeMaterial;
    }

    public static void build(RecipeOutput cons, int level, Ingredient base, Ingredient material, String string) {
        LevelUpUpgradeRecipe.build(cons, level, base, material, ResourceLocation.parse((String)string));
    }

    public static void build(RecipeOutput cons, int level, Ingredient base, Ingredient material, ResourceLocation res) {
        cons.accept(ResourceLocation.fromNamespaceAndPath((String)res.getNamespace(), (String)("level_upgrade/" + res.getPath())), (Recipe)new LevelUpUpgradeRecipe(level, base, material), null);
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        ItemStack stack = input.getItem(0);
        return ItemComponentUtils.itemLevel(stack) == this.level;
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        ItemStack stack = input.getItem(0).copy();
        ItemComponentUtils.getLeveledItem(stack, ItemComponentUtils.itemLevel(stack) + 1);
        return stack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RuneCraftoryCrafting.LEVEL_UPGRADE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RuneCraftoryCrafting.LEVEL_UP.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<LevelUpUpgradeRecipe> {
        public static final MapCodec<LevelUpUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("level").forGetter(d -> d.level), (App)Ingredient.CODEC_NONEMPTY.fieldOf("base").forGetter(d -> d.base), (App)Ingredient.CODEC_NONEMPTY.fieldOf("base").forGetter(d -> d.base)).apply((Applicative)instance, LevelUpUpgradeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, LevelUpUpgradeRecipe> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, LevelUpUpgradeRecipe>(){

            public LevelUpUpgradeRecipe decode(RegistryFriendlyByteBuf buf) {
                return new LevelUpUpgradeRecipe(buf.readInt(), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            }

            public void encode(RegistryFriendlyByteBuf buf, LevelUpUpgradeRecipe recipe) {
                buf.writeInt(recipe.level);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.base);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.upgradeMaterial);
            }
        };

        public MapCodec<LevelUpUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, LevelUpUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

