/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ArrowSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Arrow arrowentity = (Arrow)EntityType.ARROW.create((Level)level);
        arrowentity.setOwner((Entity)entity);
        float f = 1.0f;
        if (stack.getItem() instanceof ItemStaffBase) {
            f = BowItem.getPowerForTime((int)(72000 - entity.getUseItemRemainingTicks()));
        }
        arrowentity.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, f * 1.5f, 1.0f);
        arrowentity.setBaseDamage(1.7 + CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * 0.7 * (double)lvl);
        arrowentity.setRemainingFireTicks(ItemComponentUtils.getElement(stack) == ItemElement.FIRE ? 200 : 0);
        arrowentity.pickup = AbstractArrow.Pickup.DISALLOWED;
        level.addFreshEntity((Entity)arrowentity);
        level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ARROW_SHOOT, entity.getSoundSource(), 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
        return true;
    }
}

