/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.BigPlateEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BigPlateSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        Mob mob;
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Vec3 pos = null;
        if (entity instanceof Mob && (mob = (Mob)entity).getTarget() != null) {
            pos = mob.getTarget().position().add(0.0, (double)mob.getTarget().getBbHeight(), 0.0);
        }
        if (entity instanceof Player) {
            TargetingConditions target = TargetingConditions.forCombat();
            target.selector(e -> {
                if (e instanceof OwnableEntity) {
                    OwnableEntity ownable = (OwnableEntity)e;
                    if (e.getUUID().equals(ownable.getOwnerUUID())) {
                        return false;
                    }
                }
                if (!(e instanceof NPCEntity)) return true;
                NPCEntity npc = (NPCEntity)e;
                if (e.getUUID().equals(npc.getEntityToFollowUUID())) return false;
                return true;
            });
            LivingEntity nearest = level.getNearestEntity(LivingEntity.class, target, entity, entity.getX(), entity.getY(), entity.getZ(), entity.getBoundingBox().inflate(16.0));
            if (nearest != null) {
                pos = nearest.position().add(0.0, (double)nearest.getBbHeight(), 0.0);
            }
        }
        if (pos == null) {
            Vec3 horizontalLook = EntityUtils.horizontalLookAngle((Entity)entity);
            pos = entity.position().add(horizontalLook);
        }
        BigPlateEntity plate = new BigPlateEntity((Level)level, entity);
        plate.setPos(pos.x(), pos.y() + 4.0, pos.z());
        plate.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
        level.addFreshEntity((Entity)plate);
        return true;
    }
}

