/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.BoneNeedleEntity;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class BoneNeedleSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        double offset;
        Vec3 dir;
        Mob mob;
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        if (entity instanceof Mob && (mob = (Mob)entity).getTarget() != null) {
            Vec3 pos = new BoneNeedleEntity((Level)level, entity).position().add(0.0, (double)(-entity.getBbHeight()) * 0.25, 0.0);
            dir = EntityUtils.getStraightProjectileTarget(pos, (Entity)mob.getTarget()).subtract(pos);
        } else {
            dir = Vec3.directionFromRotation((float)entity.getXRot(), (float)entity.getYRot());
        }
        float[] yxRot = MathsHelper.YXRotFrom(dir);
        Vec3 side = Vec3.directionFromRotation((float)yxRot[1], (float)(yxRot[0] + 90.0f));
        Vec3 up = Vec3.directionFromRotation((float)(yxRot[1] + 90.0f), (float)yxRot[0]);
        double max = Math.abs(offset);
        double inc = max * 2.6 / 16.0;
        for (offset = -3.0; offset <= max; offset += entity.getRandom().nextDouble() * inc * 0.5 + inc * 0.5) {
            BoneNeedleEntity needle = new BoneNeedleEntity((Level)level, entity);
            Vector3d direction = new Vector3d(dir.x(), dir.y(), dir.z()).rotateAxis(0.2617993950843811 * offset, up.x(), up.y(), up.z());
            needle.shoot(direction.x(), direction.y(), direction.z(), entity.getRandom().nextFloat() * 0.1f + 0.6f, 2.0f);
            Vec3 random = needle.position().add(0.0, (double)(-entity.getBbHeight()) * 0.25, 0.0).add(side.multiply(offset * 0.5, 0.0, offset * 0.5));
            needle.setPos(random);
            needle.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            level.addFreshEntity((Entity)needle);
        }
        level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ARROW_SHOOT, entity.getSoundSource(), 1.0f, 1.2f + level.getRandom().nextFloat() * 0.1f);
        return true;
    }
}

