/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.api.registry.action.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.entities.misc.WaterLaserEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttackActions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class DoubleWaterLaserSpell
extends Spell {
    private final float range;

    public DoubleWaterLaserSpell(float range) {
        this.range = range;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Vec3 dir = entity.getViewVector(1.0f);
        Vec3 pos = entity.position().add(0.0, (double)entity.getEyeHeight() - 0.1, 0.0);
        Vec3 targetPos = ProjectileUtils.getAimTarget(entity);
        if (targetPos != null) {
            dir = targetPos.subtract(pos);
        }
        UUID other = null;
        for (int i = 0; i < 2; ++i) {
            WaterLaserEntity laser = new WaterLaserEntity((Level)level, entity, new Vector3f(i == 0 ? 0.5f : -0.5f, 0.0f, 0.5f));
            if (i == 0) {
                other = laser.getUUID();
            } else {
                laser.setTwinId(other);
            }
            laser.setRange(this.range);
            laser.setMaxTicks(entity instanceof Player ? Mth.ceil((double)PlayerModelAnimations.ANIMS.get(PlayerModelAnimations.WATER_LASER_TWO).length()) : 15);
            laser.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            Vec3 target = laser.position().add(dir);
            laser.setRotationTo(target.x(), target.y(), target.z(), 0.0f);
            laser.setupRotationAndPosition((Entity)entity, (Entity)laser);
            level.addFreshEntity((Entity)laser);
        }
        DoubleWaterLaserSpell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_WATER.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }

    @Override
    public AttackAction useAction() {
        return (AttackAction)RuneCraftoryAttackActions.DOUBLE_WATER_LASER_USE.get();
    }
}

