/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.summoners.FireWallSummoner;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireWallSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        FireWallSummoner wall = new FireWallSummoner((Level)level, entity);
        wall.setPos(FireWallSpell.offset(entity));
        Vec3 target = ProjectileUtils.getAimTarget(entity);
        if (target == null) {
            target = entity.position().add(entity.getViewVector(1.0f).scale(10.0));
        }
        wall.setTarget(target.x, target.y, target.z);
        wall.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
        level.addFreshEntity((Entity)wall);
        FireWallSpell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }

    public static Vec3 offset(LivingEntity entity) {
        Vec3 pos = entity.position().add(0.0, (double)entity.getEyeHeight(), 0.0);
        Vec3 lookDir = EntityUtils.horizontalLookAngle((Entity)entity).scale((double)entity.getBbWidth() * 0.8);
        return pos.add(lookDir).add(0.0, (double)(-entity.getBbHeight()) * 0.2, 0.0);
    }
}

