/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class HealT1Spell
extends Spell {
    public static void spawnHealParticles(LivingEntity entity) {
        if (entity.level().isClientSide) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)entity.level();
        serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, entity.getX(), entity.getY() + (double)entity.getBbHeight() + 0.5, entity.getZ(), 0, 0.0, 0.1, 0.0, 0.0);
        for (int i = 0; i < 16; ++i) {
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, entity.getRandomX(1.2), entity.getY() + (double)entity.getBbHeight() * 0.5 + entity.getRandom().nextGaussian() * 0.5 * (double)entity.getBbHeight() * 0.3, entity.getRandomZ(1.2), 1, entity.getRandom().nextGaussian() * 0.03, entity.getRandom().nextGaussian() * 0.03, entity.getRandom().nextGaussian() * 0.03, 0.0);
        }
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        List entities = level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(2.0), e -> {
            if (e == entity) {
                return true;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (e instanceof OwnableEntity) {
                    OwnableEntity ownable = (OwnableEntity)e;
                    if (player.getUUID().equals(ownable.getOwnerUUID())) return true;
                }
                if (e instanceof AbstractVillager) return true;
                if (e instanceof Animal) return true;
                if (!Platform.INSTANCE.getPlayerData((Player)player).party.isPartyMember((Entity)e)) return false;
                return true;
            }
            if (!(entity instanceof HealingPredicateEntity)) return false;
            HealingPredicateEntity healer = (HealingPredicateEntity)entity;
            return healer.healeableEntities().test((LivingEntity)e);
        });
        float healAmount = (float)(CombatUtils.getAttributeValue((Entity)entity, (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)CombatUtils.getAbilityDamageBonus(lvl, this));
        entity.heal(healAmount);
        HealT1Spell.spawnHealParticles(entity);
        entities.forEach(e -> {
            e.heal(healAmount);
            HealT1Spell.spawnHealParticles(e);
        });
        HealT1Spell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_HEAL.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

