/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.FireballEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class MultiFireballSpell
extends Spell {
    public final int amount;
    public final float angle;

    public MultiFireballSpell(int amount, float angle) {
        this.amount = amount;
        this.angle = angle;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Vec3 pos = entity.position().add(0.0, (double)entity.getEyeHeight() - 0.1, 0.0);
        Vec3 target = ProjectileUtils.getAimTarget(entity);
        Vec3 dir = target != null ? target.subtract(pos) : entity.getViewVector(1.0f);
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        float angle = -this.angle;
        float inc = this.angle * 2.0f / (float)(this.amount - 1);
        for (float y = angle; y <= this.angle; y += inc) {
            Vector3d newDir = new Vector3d(dir.x(), dir.y(), dir.z()).rotateAxis((double)(y * ((float)Math.PI / 180)), up.x(), up.y(), up.z());
            FireballEntity other = new FireballEntity((Level)level, entity, false);
            other.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            other.shoot(newDir.x(), newDir.y(), newDir.z(), 1.0f, 0.0f);
            level.addFreshEntity((Entity)other);
        }
        MultiFireballSpell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

