/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.common.advancements.CropHarvestTrigger;
import io.github.flemmli97.runecraftory.common.blocks.ExtendedCropBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.Growable;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandData;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixin.CropBlockAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class CropUtils {
    public static void attemptGiantize(ServerLevel level, BlockPos cropPos, Growable crop, BlockState state, float progress, CropProperties props) {
        if (crop.runecraftory$isAtMaxAge(state) && props.getGiantVersion().isPresent() && (double)progress >= 0.5) {
            if (state.is(props.getGiantVersion().get())) {
                return;
            }
            Block block = state.getBlock();
            if (block instanceof ExtendedCropBlock) {
                ExtendedCropBlock blockCrop = (ExtendedCropBlock)block;
                int age = (Integer)state.getValue((Property)blockCrop.getAgeProperty());
                if (age != blockCrop.getGiantAge()) {
                    level.setBlock(cropPos, (BlockState)state.setValue((Property)blockCrop.getAgeProperty(), (Comparable)Integer.valueOf(blockCrop.getGiantAge())), 3);
                } else if (progress >= 1.0f) {
                    FarmlandHandler.get(level.getServer()).scheduleGiantCropMerge(level, cropPos, props.getGiantVersion().get().defaultBlockState());
                }
            } else if (progress >= 1.0f) {
                FarmlandHandler.get(level.getServer()).scheduleGiantCropMerge(level, cropPos, props.getGiantVersion().get().defaultBlockState());
            }
        }
    }

    public static CropProperties getPropertiesFor(CropBlock crop) {
        return DataPackHandler.INSTANCE.cropManager().get(((CropBlockAccessor)crop).getSeedItem().asItem());
    }

    public static void modifyCropDrops(BlockState state, LootParams.Builder builder, CropBlock block, List<ItemStack> list) {
        CropProperties prop = CropUtils.getPropertiesFor(block);
        if (prop != null) {
            int itemLevel;
            Vec3 pos = (Vec3)builder.getOptionalParameter(LootContextParams.ORIGIN);
            int n = itemLevel = pos != null ? CropUtils.getCropLevel(builder.getLevel(), BlockPos.containing((Position)pos)) : 1;
            if (block.isMaxAge(state)) {
                ArrayList<ItemStack> remove = new ArrayList<ItemStack>();
                boolean removedSeed = list.size() < 2;
                for (ItemStack stack : list) {
                    if (removedSeed || !stack.is(((CropBlockAccessor)block).getSeedItem().asItem())) continue;
                    remove.add(stack);
                    removedSeed = true;
                }
                list.removeIf(remove::contains);
                list.forEach(s -> CropUtils.modifyStack(prop, s, itemLevel));
            } else if (block instanceof ExtendedCropBlock) {
                list.clear();
            }
        }
    }

    private static int getCropLevel(ServerLevel level, BlockPos pos) {
        return FarmlandHandler.get(level.getServer()).getData(level, new BlockPos((Vec3i)pos)).map(FarmlandData::getCropLevel).orElse(1);
    }

    private static void modifyStack(CropProperties props, ItemStack stack, int level) {
        if (stack.is(RunecraftoryTags.Items.CROPS)) {
            stack.setCount(props.maxDrops());
            ItemComponentUtils.getLeveledItem(stack, level);
        }
    }

    public static void harvestCropRightClick(BlockState state, Level level, BlockPos pos, Entity entity, ItemStack stack, CropProperties props, InteractionHand hand, Function<ItemStack, ItemStack> stackConsumer) {
        Block block;
        ServerLevel serverLevel;
        block11: {
            block10: {
                if (!(level instanceof ServerLevel)) break block10;
                serverLevel = (ServerLevel)level;
                block = state.getBlock();
                if (block instanceof CropBlock) break block11;
            }
            return;
        }
        CropBlock cropBlock = (CropBlock)block;
        if (stackConsumer != null) {
            Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, null, (Entity)entity, (ItemStack)stack).forEach(s -> {
                ItemStack rest = (ItemStack)stackConsumer.apply((ItemStack)s);
                if (!rest.isEmpty()) {
                    Block.popResource((Level)level, (BlockPos)pos, (ItemStack)rest);
                }
            });
            state.spawnAfterBreak(serverLevel, pos, ItemStack.EMPTY, true);
        } else {
            Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)entity, (ItemStack)stack);
        }
        level.levelEvent(2001, pos, Block.getId((BlockState)state));
        if (props != null && props.regrowable() && FarmlandHandler.get(serverLevel.getServer()).getData(serverLevel, pos.below()).map(d -> d.getHealth() > 0).orElse(false).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)((CropBlockAccessor)cropBlock).cropAgeProperty(), (Comparable)Integer.valueOf(0)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ((CropHarvestTrigger)((Object)RuneCraftoryCriteria.HARVEST_CROP.get())).trigger(player, state);
            if (cropBlock.isMaxAge(state)) {
                CropUtils.spawnRuney(player, pos);
                LevelCalc.levelSkill(Platform.INSTANCE.getPlayerData((Player)player), Skills.FARMING, 2.0f);
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.swing(hand, true);
        }
    }

    public static void spawnRuney(ServerPlayer player, BlockPos pos) {
        if (player.getRandom().nextFloat() < GeneralConfig.runeyChance) {
            Entity entity = (double)player.getRandom().nextFloat() < 0.4 ? ((EntityType)RuneCraftoryEntities.RUNEY.get()).create((Level)player.serverLevel()) : ((EntityType)RuneCraftoryEntities.STAT_BONUS.get()).create((Level)player.serverLevel());
            entity.setPos((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5);
            player.level().addFreshEntity(entity);
        }
    }
}

