/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.mixin.BiomeAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public class SeasonUtils {
    public static boolean coldEnoughForSnowSeason(LevelReader level, BlockPos pos, Biome biome) {
        if (!GeneralConfig.seasonedSnow) {
            return false;
        }
        return (double)SeasonUtils.seasonBasedTemp(level, pos, biome) < 0.15;
    }

    public static float seasonBasedTemp(LevelReader level, BlockPos pos, Biome biome) {
        float temp = ((BiomeAccessor)biome).biomeTemp(pos);
        if (!GeneralConfig.seasonedSnow) {
            return temp;
        }
        if (!(level instanceof Level)) {
            return temp;
        }
        Level actual = (Level)level;
        Season season = Calendar.get(actual).currentSeason();
        switch (season) {
            case SUMMER: {
                temp += 0.1f;
                break;
            }
            case AUTUMN: {
                temp -= 0.25f;
                break;
            }
            case WINTER: {
                temp -= 0.8f;
            }
        }
        return temp;
    }

    public static void doSnowMelt(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
    }
}

