/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.data;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.blocks.util.DailyUpdateable;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.data.BarnData;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.common.world.data.NPCHandler;
import io.github.flemmli97.runecraftory.common.world.data.NPCSpawner;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RunecraftorySavedData
extends SavedData {
    private static final String IDENTIFIER = "RunecraftorySaveData";
    private static final SavedData.Factory<RunecraftorySavedData> FACTORY = new SavedData.Factory(RunecraftorySavedData::new, RunecraftorySavedData::new, DataFixTypes.LEVEL);
    private final Calendar calendar = new Calendar(this);
    private final Set<DailyUpdateable> updateTracker = Sets.newConcurrentHashSet();
    private final Map<UUID, Set<BarnData>> playerBarns = new HashMap<UUID, Set<BarnData>>();
    private final Map<ResourceKey<Level>, Long2ObjectMap<BarnData>> positionBarnMap = new HashMap<ResourceKey<Level>, Long2ObjectMap<BarnData>>();
    private final Map<UUID, Set<UnloadedPartyMember>> unloadedPartyMembers = new HashMap<UUID, Set<UnloadedPartyMember>>();
    private final Map<UUID, Set<UUID>> toRemovePartyMembers = new HashMap<UUID, Set<UUID>>();
    public final NPCHandler npcHandler = new NPCHandler();
    private final NPCSpawner npcSpawner = new NPCSpawner();
    private int updateDelay;
    private int lastUpdateDay;

    private RunecraftorySavedData() {
    }

    private RunecraftorySavedData(CompoundTag tag, HolderLookup.Provider provider) {
        this.load(tag, provider);
    }

    public static RunecraftorySavedData get(MinecraftServer server) {
        return (RunecraftorySavedData)server.overworld().getDataStorage().computeIfAbsent(FACTORY, IDENTIFIER);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void tick(ServerLevel level) {
        boolean isUpdateTime = WorldUtils.canUpdateDaily((Level)level, this.lastUpdateDay);
        this.calendar.tick(level, isUpdateTime);
        this.npcSpawner.tick(level, true, true);
        if (isUpdateTime) {
            this.updateTracker.removeIf(DailyUpdateable::inValid);
            this.updateTracker.forEach(update -> update.update(level));
            this.lastUpdateDay = WorldUtils.day((Level)level);
        }
    }

    public void addToTracker(DailyUpdateable update) {
        this.updateTracker.add(update);
    }

    public boolean removeFromTracker(DailyUpdateable update) {
        return this.updateTracker.remove(update);
    }

    public BarnData getOrCreateFor(UUID player, Level level, BlockPos pos) {
        BarnData data = (BarnData)this.positionBarnMap.computeIfAbsent((ResourceKey<Level>)level.dimension(), k -> new Long2ObjectOpenHashMap()).computeIfAbsent(pos.asLong(), l -> new BarnData(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos)));
        this.playerBarns.computeIfAbsent(player, uuid -> new HashSet()).add(data);
        this.setDirty();
        return data;
    }

    public Set<BarnData> barnsOf(UUID player) {
        return ImmutableSet.copyOf((Collection)this.playerBarns.getOrDefault(player, Set.of()));
    }

    @Nullable
    public BarnData barnAt(GlobalPos pos) {
        Long2ObjectMap<BarnData> map = this.positionBarnMap.get(pos.dimension());
        if (map != null) {
            return (BarnData)map.get(pos.pos().asLong());
        }
        return null;
    }

    @Nullable
    public BarnData findFittingBarn(BaseMonster monster, UUID owner) {
        return this.barnsOf(owner).stream().filter(b -> b.hasCapacityFor(monster)).findFirst().orElse(null);
    }

    @Nullable
    public BarnData findNearestFittingBarn(BaseMonster monster, int radius) {
        if (monster.getOwnerUUID() == null) {
            return null;
        }
        return this.barnsOf(monster.getOwnerUUID()).stream().filter(b -> b.pos.dimension() == monster.level().dimension() && new AABB(monster.blockPosition()).inflate((double)radius).contains(Vec3.atCenterOf((Vec3i)b.pos.pos())) && b.hasCapacityFor(monster)).findFirst().orElse(null);
    }

    @Nullable
    public BarnData findFittingBarn(BaseMonster monster) {
        if (monster.getOwnerUUID() == null) {
            return null;
        }
        return this.findFittingBarn(monster, monster.getOwnerUUID());
    }

    public void removeMonsterFromPlayer(UUID player, BaseMonster monster) {
        this.playerBarns.getOrDefault(player, Set.of()).forEach(b -> b.removeMonster(monster));
    }

    public void removeBarn(UUID player, GlobalPos pos) {
        Long2ObjectMap<BarnData> map = this.positionBarnMap.get(pos.dimension());
        if (map != null) {
            BarnData old = (BarnData)map.remove(pos.pos().asLong());
            this.playerBarns.computeIfAbsent(player, uuid -> new HashSet()).remove(old);
            old.remove();
            this.setDirty();
        }
    }

    public void safeUnloadedPartyMembers(LivingEntity entity) {
        NPCEntity npc;
        BaseMonster monster;
        if (entity instanceof BaseMonster && (monster = (BaseMonster)entity).getOwnerUUID() != null) {
            this.unloadedPartyMembers.computeIfAbsent(monster.getOwnerUUID(), o -> new HashSet()).add(new UnloadedPartyMember(entity.getUUID(), GlobalPos.of((ResourceKey)entity.level().dimension(), (BlockPos)entity.blockPosition())));
        } else if (entity instanceof NPCEntity && (npc = (NPCEntity)entity).getEntityToFollowUUID() != null) {
            this.unloadedPartyMembers.computeIfAbsent(npc.getEntityToFollowUUID(), o -> new HashSet()).add(new UnloadedPartyMember(entity.getUUID(), GlobalPos.of((ResourceKey)entity.level().dimension(), (BlockPos)entity.blockPosition())));
        }
    }

    public Set<UnloadedPartyMember> getUnloadedPartyMembersFor(Player player) {
        return this.unloadedPartyMembers.computeIfAbsent(player.getUUID(), o -> new HashSet());
    }

    public void toRemovePartyMember(LivingEntity entity) {
        NPCEntity npc;
        BaseMonster monster;
        if (entity instanceof BaseMonster && (monster = (BaseMonster)entity).getOwnerUUID() != null) {
            this.toRemovePartyMembers.computeIfAbsent(monster.getOwnerUUID(), o -> new HashSet()).add(entity.getUUID());
        } else if (entity instanceof NPCEntity && (npc = (NPCEntity)entity).getEntityToFollowUUID() != null) {
            this.toRemovePartyMembers.computeIfAbsent(npc.getEntityToFollowUUID(), o -> new HashSet()).add(entity.getUUID());
        }
    }

    public Set<UUID> removedPartyMembersFor(Player player) {
        return this.toRemovePartyMembers.computeIfAbsent(player.getUUID(), o -> new HashSet());
    }

    public void load(CompoundTag compoundNBT, HolderLookup.Provider provider) {
        this.calendar.read(compoundNBT);
        this.lastUpdateDay = compoundNBT.getInt("LastUpdateDay");
        CompoundTag barns = compoundNBT.getCompound("PlayerBarns");
        barns.getAllKeys().forEach(key -> {
            UUID uuid = UUID.fromString(key);
            ListTag list = barns.getList(key, 10);
            Set map = this.playerBarns.computeIfAbsent(uuid, u -> new HashSet());
            list.forEach(t -> {
                BarnData data = BarnData.fromTag((CompoundTag)t);
                map.add(data);
                this.positionBarnMap.computeIfAbsent((ResourceKey<Level>)data.pos.dimension(), k -> new Long2ObjectOpenHashMap()).put(data.pos.pos().asLong(), (Object)data);
            });
        });
        CompoundTag unloadedParties = compoundNBT.getCompound("UnloadedParties");
        unloadedParties.getAllKeys().forEach(key -> {
            UUID uuid = UUID.fromString(key);
            ListTag list = unloadedParties.getList(key, 10);
            Set map = this.unloadedPartyMembers.computeIfAbsent(uuid, u -> new HashSet());
            list.forEach(t -> {
                CompoundTag cTag = (CompoundTag)t;
                map.add(new UnloadedPartyMember(UUID.fromString(cTag.getString("UUID")), (GlobalPos)GlobalPos.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)cTag.get("Pos"))).getOrThrow()));
            });
        });
        CompoundTag removedPartyMembers = compoundNBT.getCompound("RemovedPartyMembers");
        removedPartyMembers.getAllKeys().forEach(key -> {
            UUID uuid = UUID.fromString(key);
            ListTag list = removedPartyMembers.getList(key, 11);
            Set uuids = this.toRemovePartyMembers.computeIfAbsent(uuid, u -> new HashSet());
            list.forEach(t -> uuids.add(NbtUtils.loadUUID((Tag)t)));
        });
        this.npcHandler.load(compoundNBT.getCompound("NPCHandler"), provider);
    }

    public CompoundTag save(CompoundTag compoundNBT, HolderLookup.Provider provider) {
        this.calendar.write(compoundNBT);
        compoundNBT.putInt("LastUpdateDay", this.lastUpdateDay);
        CompoundTag barns = new CompoundTag();
        this.playerBarns.forEach((uuid, pB) -> {
            ListTag pBTag = new ListTag();
            pB.forEach(b -> {
                if (!b.isInvalid()) {
                    pBTag.add((Object)b.save());
                }
            });
            barns.put(uuid.toString(), (Tag)pBTag);
        });
        compoundNBT.put("PlayerBarns", (Tag)barns);
        CompoundTag unloadedParties = new CompoundTag();
        this.unloadedPartyMembers.forEach((uuid, pairs) -> {
            if (!pairs.isEmpty()) {
                ListTag pTags = new ListTag();
                pairs.forEach(p -> {
                    CompoundTag pTag = new CompoundTag();
                    pTag.putString("UUID", p.uuid().toString());
                    GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)p.pos()).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(t -> pTag.put("Pos", t));
                    pTags.add((Object)pTag);
                });
                unloadedParties.put(uuid.toString(), (Tag)pTags);
            }
        });
        compoundNBT.put("UnloadedParties", (Tag)unloadedParties);
        CompoundTag removedPartyMembers = new CompoundTag();
        this.toRemovePartyMembers.forEach((uuid, uuids) -> {
            if (!uuids.isEmpty()) {
                ListTag pTags = new ListTag();
                uuids.forEach(member -> pTags.add((Object)NbtUtils.createUUID((UUID)member)));
                removedPartyMembers.put(uuid.toString(), (Tag)pTags);
            }
        });
        compoundNBT.put("RemovedPartyMembers", (Tag)removedPartyMembers);
        compoundNBT.put("NPCHandler", (Tag)this.npcHandler.save(provider));
        return compoundNBT;
    }

    public record UnloadedPartyMember(UUID uuid, GlobalPos pos) {
        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof UnloadedPartyMember) {
                UnloadedPartyMember other = (UnloadedPartyMember)obj;
                return other.uuid.equals(this.uuid);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.uuid.hashCode();
        }
    }
}

