/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.features.trees;

import com.mojang.serialization.Codec;
import io.github.flemmli97.runecraftory.common.blocks.TreeRootBlock;
import io.github.flemmli97.runecraftory.common.blocks.entity.TreeBlockEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.world.features.trees.FruitTreeSproutConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class FruitTreeSproutFeature
extends Feature<FruitTreeSproutConfiguration> {
    public FruitTreeSproutFeature(Codec<FruitTreeSproutConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<FruitTreeSproutConfiguration> context) {
        BlockPos soil = context.origin().below();
        if (context.level().isStateAtPosition(soil, s -> !s.is((Block)RuneCraftoryBlocks.TREE_SOIL.get()))) {
            context.level().setBlock(soil, ((TreeRootBlock)((Object)RuneCraftoryBlocks.TREE_SOIL.get())).defaultBlockState(), 3);
        }
        BlockPos above = context.origin().above();
        BlockEntity blockEntity = context.level().getBlockEntity(context.origin());
        context.level().setBlock(above, ((FruitTreeSproutConfiguration)context.config()).trunkProvider().getState(context.random(), above), 3);
        ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
        for (Direction dir : Direction.values()) {
            if (dir == Direction.DOWN) continue;
            BlockPos pos = above.relative(dir);
            context.level().setBlock(pos, (BlockState)((FruitTreeSproutConfiguration)context.config()).foliageProvider().getState(context.random(), pos).setValue((Property)BlockStateProperties.DISTANCE, (Comparable)Integer.valueOf(1)), 3);
            leaves.add(pos);
        }
        if (blockEntity instanceof TreeBlockEntity) {
            TreeBlockEntity tree = (TreeBlockEntity)blockEntity;
            tree.updateTreeLogs((BlockGetter)context.level(), List.of(above));
            tree.updateTreeLeaves((LevelAccessor)context.level(), leaves);
        }
        return true;
    }
}

