/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;

public class FilterHolderSet<T>
implements HolderSet<T> {
    public static MapCodec<Structure.StructureSettings> FILTERED_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FilterHolderSet.codec(Registries.BIOME, Biome.CODEC, false).fieldOf("biomes").forGetter(Structure.StructureSettings::biomes), (App)Codec.simpleMap((Codec)MobCategory.CODEC, (Codec)StructureSpawnOverride.CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])MobCategory.values())).fieldOf("spawn_overrides").forGetter(Structure.StructureSettings::spawnOverrides), (App)GenerationStep.Decoration.CODEC.fieldOf("step").forGetter(Structure.StructureSettings::step), (App)TerrainAdjustment.CODEC.optionalFieldOf("terrain_adaptation", (Object)TerrainAdjustment.NONE).forGetter(Structure.StructureSettings::terrainAdaptation)).apply((Applicative)instance, Structure.StructureSettings::new));
    private final HolderSet<T> base;
    private final HolderSet<T> filter;
    private Set<Holder<T>> set = null;
    private List<Holder<T>> list = null;

    public static <T> MapCodec<HolderSet<T>> codec(ResourceKey<? extends Registry<T>> registryKey, Codec<Holder<T>> holderCodec, boolean forceList) {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.create((ResourceKey)registryKey, (Codec)holderCodec, (boolean)forceList).fieldOf("base").forGetter(FilterHolderSet::base), (App)HolderSetCodec.create((ResourceKey)registryKey, (Codec)holderCodec, (boolean)forceList).fieldOf("filter").forGetter(FilterHolderSet::filter)).apply((Applicative)builder, FilterHolderSet::new)).xmap(Function.identity(), h -> {
            FilterHolderSet filterHolderSet;
            if (h instanceof FilterHolderSet) {
                FilterHolderSet filterHolderSet2 = (FilterHolderSet)h;
                filterHolderSet = filterHolderSet2;
            } else {
                filterHolderSet = new FilterHolderSet(h, HolderSet.empty());
            }
            return filterHolderSet;
        });
    }

    public HolderSet<T> base() {
        return this.base;
    }

    public HolderSet<T> filter() {
        return this.filter;
    }

    public FilterHolderSet(HolderSet<T> base, HolderSet<T> filter) {
        this.base = base;
        this.filter = filter;
    }

    protected Set<Holder<T>> createSet() {
        return this.base.stream().filter(holder -> !this.filter.contains(holder)).collect(Collectors.toSet());
    }

    public Set<Holder<T>> getSet() {
        Set<Holder<T>> thisSet = this.set;
        if (thisSet == null) {
            Set<Holder<T>> set = this.createSet();
            this.set = set;
            return set;
        }
        return thisSet;
    }

    public List<Holder<T>> getList() {
        List<Holder<T>> thisList = this.list;
        if (thisList == null) {
            List<Holder<T>> list = List.copyOf(this.getSet());
            this.list = list;
            return list;
        }
        return thisList;
    }

    public Stream<Holder<T>> stream() {
        return this.getList().stream();
    }

    public int size() {
        return this.getList().size();
    }

    public Either<TagKey<T>, List<Holder<T>>> unwrap() {
        return Either.right(this.getList());
    }

    public Optional<Holder<T>> getRandomElement(RandomSource rand) {
        List<Holder<T>> list = this.getList();
        int size = list.size();
        return size > 0 ? Optional.of(list.get(rand.nextInt(size))) : Optional.empty();
    }

    public Holder<T> get(int i) {
        return this.getList().get(i);
    }

    public boolean contains(Holder<T> holder) {
        return this.getSet().contains(holder);
    }

    public boolean canSerializeIn(HolderOwner<T> holderOwner) {
        return this.base.canSerializeIn(holderOwner) && this.filter.canSerializeIn(holderOwner);
    }

    public Optional<TagKey<T>> unwrapKey() {
        return Optional.empty();
    }

    public Iterator<Holder<T>> iterator() {
        return this.getList().iterator();
    }
}

