/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryStructures;
import io.github.flemmli97.runecraftory.common.world.structure.ExtendedJigsawStructure;
import io.github.flemmli97.runecraftory.common.world.structure.FilterHolderSet;
import io.github.flemmli97.runecraftory.common.world.structure.JigsawStructureData;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;

public class NetherJigsawStructure
extends ExtendedJigsawStructure {
    public static final MapCodec<NetherJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FilterHolderSet.FILTERED_CODEC.forGetter(d -> d.settings), (App)JigsawStructureData.CODEC.forGetter(d -> d.data), (App)Codec.INT.fieldOf("min_y").forGetter(d -> d.min), (App)Codec.INT.fieldOf("max_y").forGetter(d -> d.max)).apply((Applicative)instance, NetherJigsawStructure::new));
    private final int min;
    private final int max;

    public NetherJigsawStructure(Structure.StructureSettings settings, JigsawStructureData data, int min, int max) {
        super(settings, data);
        this.min = min;
        this.max = max;
    }

    public static BlockPos tryFindFittingPos(Structure.GenerationContext context, int min, int max) {
        BlockPos center = context.chunkPos().getMiddleBlockPosition(0);
        NoiseColumn column = context.chunkGenerator().getBaseColumn(center.getX(), center.getZ(), context.heightAccessor(), context.randomState());
        ArrayList<BlockPos> matching = new ArrayList<BlockPos>();
        for (int i = min; i < max; ++i) {
            BlockState state = column.getBlock(i);
            if (state.isAir() || !column.getBlock(i + 1).isAir()) continue;
            matching.add(new BlockPos(center.getX(), i, center.getZ()));
        }
        if (matching.isEmpty()) {
            return null;
        }
        context.random().setLargeFeatureSeed(context.seed(), context.chunkPos().x, context.chunkPos().z);
        return (BlockPos)matching.get(context.random().nextInt(matching.size()));
    }

    @Override
    protected BlockPos calculatePosition(Structure.GenerationContext context) {
        return NetherJigsawStructure.tryFindFittingPos(context, this.min, this.max);
    }

    @Override
    public StructureType<?> type() {
        return (StructureType)RuneCraftoryStructures.NETHER_STRUCTURE.get();
    }
}

