/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.forge.integration.top;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.blocks.MonsterBarnBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeBaseBlock;
import io.github.flemmli97.runecraftory.common.blocks.entity.MonsterBarnBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.entity.TreeBlockEntity;
import io.github.flemmli97.runecraftory.common.world.data.BarnData;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockProvider
implements IProbeInfoProvider {
    public static final ResourceLocation ID = RuneCraftory.modRes("block_provider");

    public ResourceLocation getID() {
        return ID;
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
        MonsterBarnBlockEntity barn;
        BarnData data;
        BlockEntity entity;
        if (blockState.getBlock() instanceof MonsterBarnBlock && (entity = level.getBlockEntity(iProbeHitData.getPos())) instanceof MonsterBarnBlockEntity && (data = (barn = (MonsterBarnBlockEntity)entity).getBarnData()) != null) {
            Component sizeText;
            int size = data.getSize();
            Component component = sizeText = size > 1 ? BlockProvider.withTextColored((Component)Component.literal((String)("" + size)), ChatFormatting.GREEN) : BlockProvider.withTextColored((Component)Component.literal((String)("" + size)), ChatFormatting.DARK_RED);
            if (!data.hasRoof()) {
                iProbeInfo.text((Component)Component.translatable((String)"runecraftory.dependency.tooltips.barn.1", (Object[])new Object[]{sizeText}));
            } else {
                iProbeInfo.text((Component)Component.translatable((String)"runecraftory.dependency.tooltips.barn.1.alt", (Object[])new Object[]{BlockProvider.withTextColored((Component)Component.translatable((String)("" + data.roofHeight())), ChatFormatting.YELLOW), sizeText}));
            }
            iProbeInfo.text((Component)Component.translatable((String)"runecraftory.dependency.tooltips.barn.2", (Object[])new Object[]{data.usedCapacity(), data.getCapacity()}));
        }
        if (blockState.getBlock() instanceof TreeBaseBlock && (entity = level.getBlockEntity(iProbeHitData.getPos())) instanceof TreeBlockEntity) {
            TreeBlockEntity tree = (TreeBlockEntity)entity;
            iProbeInfo.text((Component)Component.translatable((String)"runecraftory.dependency.tooltips.tree", (Object[])new Object[]{tree.getHealth()}));
        }
    }

    private static Component withTextColored(Component other, ChatFormatting formatting) {
        return Component.literal((String)("\u00a7" + formatting.getChar())).append(other);
    }
}

