/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.rei;

import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.integration.rei.CraftingIdentifier;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class SextupleDisplay
extends BasicDisplay {
    private final CraftingIdentifier type;
    private final RecipeHolder<SextupleRecipe> recipe;

    public SextupleDisplay(RecipeHolder<SextupleRecipe> recipe, CraftingIdentifier identifier) {
        super(((SextupleRecipe)recipe.value()).getIngredients().stream().map(EntryIngredients::ofIngredient).toList(), List.of(EntryIngredient.of((EntryStack)EntryStacks.of((ItemStack)((SextupleRecipe)recipe.value()).getResultItem((HolderLookup.Provider)BasicDisplay.registryAccess())))), Optional.of(recipe.id()));
        this.recipe = recipe;
        this.type = identifier;
    }

    private SextupleDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<ResourceLocation> location, CompoundTag tag) {
        super(inputs, outputs, location);
        this.recipe = location.flatMap(resourceLocation -> RecipeManagerContext.getInstance().getRecipeManager().byKey(resourceLocation)).orElse(null);
        this.type = CraftingIdentifier.get(CraftingType.values()[tag.getInt("CraftingType")]);
    }

    public boolean shouldShowDisplay(boolean asIngredient) {
        return Minecraft.getInstance().player == null || this.recipe() == null || (asIngredient ? Platform.INSTANCE.getPlayerData((Player)Minecraft.getInstance().player).getRecipeKeeper().isUnlocked(this.recipe()) : Platform.INSTANCE.getPlayerData((Player)Minecraft.getInstance().player).getRecipeKeeper().isUnlockedForCrafting(this.recipe()));
    }

    @Nullable
    public RecipeHolder<SextupleRecipe> recipe() {
        return this.recipe;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.type.identifier();
    }

    public static BasicDisplay.Serializer<SextupleDisplay> serializer() {
        return BasicDisplay.Serializer.of(SextupleDisplay::new, (display, tag) -> tag.putInt("CraftingType", display.type.craftingType().ordinal()));
    }
}

