/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.neoforge.data;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.advancements.CropHarvestTrigger;
import io.github.flemmli97.runecraftory.common.advancements.LevelTrigger;
import io.github.flemmli97.runecraftory.common.advancements.MoneyTrigger;
import io.github.flemmli97.runecraftory.common.advancements.ShippingTrigger;
import io.github.flemmli97.runecraftory.common.advancements.ShopTrigger;
import io.github.flemmli97.runecraftory.common.advancements.SkillLevelTrigger;
import io.github.flemmli97.runecraftory.common.advancements.TameMonsterTrigger;
import io.github.flemmli97.runecraftory.common.lib.LibAdvancements;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ImpossibleTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class AdvancementGen
extends AdvancementProvider {
    public AdvancementGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new RunecraftoryAdvancements()));
    }

    public static class RunecraftoryAdvancements
    implements AdvancementProvider.AdvancementGenerator {
        public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> cons, ExistingFileHelper fileHelper) {
            AdvancementHolder root = Advancement.Builder.advancement().display((ItemLike)RuneCraftoryItems.MEDICINAL_HERB.get(), (Component)Component.translatable((String)"runecraftory.advancements.root.title"), (Component)Component.translatable((String)"runecraftory.advancements.root.description"), ResourceLocation.withDefaultNamespace((String)"textures/block/dirt.png"), AdvancementType.TASK, false, false, false).addCriterion("crafting_table", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Blocks.CRAFTING_TABLE})).save(cons, LibAdvancements.ROOT.toString());
            AdvancementHolder tameFirst = Advancement.Builder.advancement().parent(root).display((ItemLike)SpawnEgg.fromType((EntityType)((EntityType)RuneCraftoryEntities.WOOLY.get())).get(), (Component)Component.translatable((String)"runecraftory.advancements.tame.first.title"), (Component)Component.translatable((String)"runecraftory.advancements.tame.first.description"), null, AdvancementType.TASK, true, true, false).addCriterion("tame_monster", TameMonsterTrigger.TriggerInstance.of(1)).save(cons, LibAdvancements.TAME_FIRST.toString());
            AdvancementHolder tameTen = TameMonsterTrigger.TriggerInstance.amountOfSteps(Advancement.Builder.advancement().parent(tameFirst).display((ItemLike)RuneCraftoryItems.MONSTER_BARN.get(), (Component)Component.translatable((String)"runecraftory.advancements.tame.ten.title"), (Component)Component.translatable((String)"runecraftory.advancements.tame.ten.description"), null, AdvancementType.GOAL, true, true, false), "tame_monster", 10, false).save(cons, LibAdvancements.TAME_TEN.toString());
            AdvancementHolder tameBoss = Advancement.Builder.advancement().parent(tameFirst).display((ItemLike)RuneCraftoryItems.AMBROSIAS_THORNS.get(), (Component)Component.translatable((String)"runecraftory.advancements.tame.boss.title"), (Component)Component.translatable((String)"runecraftory.advancements.tame.boss.description"), null, AdvancementType.TASK, true, true, false).addCriterion("tame_boss_monster", TameMonsterTrigger.TriggerInstance.bossOf(1)).save(cons, LibAdvancements.TAME_BOSS_FIRST.toString());
            AdvancementHolder tameBossFive = TameMonsterTrigger.TriggerInstance.amountOfSteps(Advancement.Builder.advancement().parent(tameBoss).display(RunecraftoryAdvancements.glowing((ItemLike)SpawnEgg.fromType((EntityType)((EntityType)RuneCraftoryEntities.AMBROSIA.get())).get()), (Component)Component.translatable((String)"runecraftory.advancements.tame.boss.five.title"), (Component)Component.translatable((String)"runecraftory.advancements.tame.boss.five.description"), null, AdvancementType.GOAL, true, true, false), "tame_bosses", 5, true).save(cons, LibAdvancements.TAME_BOSS_FIVE.toString());
            AdvancementHolder tameBossAll = RunecraftoryAdvancements.allBosses(Advancement.Builder.advancement().parent(tameBossFive).display((ItemLike)RuneCraftoryItems.SCALE_LEGEND.get(), (Component)Component.translatable((String)"runecraftory.advancements.tame.boss.all.title"), (Component)Component.translatable((String)"runecraftory.advancements.tame.boss.all.description"), null, AdvancementType.CHALLENGE, true, true, false)).save(cons, LibAdvancements.TAME_BOSS_ALL.toString());
            AdvancementHolder shipping = Advancement.Builder.advancement().parent(root).display((ItemLike)RuneCraftoryItems.SHIPPING_BIN.get(), (Component)Component.translatable((String)"runecraftory.advancements.shipping.title"), (Component)Component.translatable((String)"runecraftory.advancements.shipping.description"), null, AdvancementType.TASK, true, true, false).addCriterion("ship_item", ShippingTrigger.TriggerInstance.shipAny(1)).save(cons, LibAdvancements.SHIP_FIRST.toString());
            AdvancementHolder shippingFifty = Advancement.Builder.advancement().parent(shipping).display((ItemLike)RuneCraftoryItems.SHIPPING_BIN.get(), (Component)Component.translatable((String)"runecraftory.advancements.shipping.fifty.title"), (Component)Component.translatable((String)"runecraftory.advancements.shipping.fifty.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("ship_item", ShippingTrigger.TriggerInstance.shipAny(50)).save(cons, LibAdvancements.SHIP_FIFTY.toString());
            AdvancementHolder shop = Advancement.Builder.advancement().parent(shipping).display((ItemLike)Items.GOLD_INGOT, (Component)Component.translatable((String)"runecraftory.advancements.shop.title"), (Component)Component.translatable((String)"runecraftory.advancements.shop.description"), null, AdvancementType.TASK, true, true, false).addCriterion("buy_item", ShopTrigger.TriggerInstance.buyAny()).save(cons, LibAdvancements.SHOP.toString());
            AdvancementHolder hundred_k = Advancement.Builder.advancement().parent(shop).display((ItemLike)Items.GOLD_BLOCK, (Component)Component.translatable((String)"runecraftory.advancements.100k.title"), (Component)Component.translatable((String)"runecraftory.advancements.100k.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("have_money", MoneyTrigger.TriggerInstance.of(100000)).save(cons, LibAdvancements.MONEY_100K.toString());
            AdvancementHolder million = Advancement.Builder.advancement().parent(hundred_k).display((ItemLike)RuneCraftoryItems.EMERY_FLOWER.get(), (Component)Component.translatable((String)"runecraftory.advancements.million.title"), (Component)Component.translatable((String)"runecraftory.advancements.million.description"), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("have_money", MoneyTrigger.TriggerInstance.of(1000000)).save(cons, LibAdvancements.MONEY_1M.toString());
            AdvancementHolder skill = Advancement.Builder.advancement().parent(root).display((ItemLike)SpawnEgg.fromType((EntityType)((EntityType)RuneCraftoryEntities.WOOLY.get())).get(), (Component)Component.translatable((String)"runecraftory.advancements.skill.weapon.5.title"), (Component)Component.translatable((String)"runecraftory.advancements.skill.weapon.5.description"), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("short_sword", SkillLevelTrigger.TriggerInstance.of(Skills.SHORTSWORD, 5)).addCriterion("long_sword", SkillLevelTrigger.TriggerInstance.of(Skills.LONGSWORD, 5)).addCriterion("spear", SkillLevelTrigger.TriggerInstance.of(Skills.SPEAR, 5)).addCriterion("axes_hammer", SkillLevelTrigger.TriggerInstance.of(Skills.HAMMERAXE, 5)).addCriterion("first", SkillLevelTrigger.TriggerInstance.of(Skills.FIST, 5)).save(cons, LibAdvancements.SKILL_5.toString());
            AdvancementHolder skill10 = Advancement.Builder.advancement().parent(root).display((ItemLike)Items.EXPERIENCE_BOTTLE, (Component)Component.translatable((String)"runecraftory.advancements.skill.10.title"), (Component)Component.translatable((String)"runecraftory.advancements.skill.10.description"), null, AdvancementType.TASK, true, true, false).addCriterion("skill", SkillLevelTrigger.TriggerInstance.of(10)).save(cons, LibAdvancements.SKILL_10.toString());
            AdvancementHolder skill25 = Advancement.Builder.advancement().parent(skill10).display((ItemLike)Items.EXPERIENCE_BOTTLE, (Component)Component.translatable((String)"runecraftory.advancements.skill.25.title"), (Component)Component.translatable((String)"runecraftory.advancements.skill.25.description"), null, AdvancementType.TASK, true, true, false).addCriterion("skill", SkillLevelTrigger.TriggerInstance.of(25)).save(cons, LibAdvancements.SKILL_25.toString());
            AdvancementHolder skill50 = Advancement.Builder.advancement().parent(skill25).display((ItemLike)Items.EXPERIENCE_BOTTLE, (Component)Component.translatable((String)"runecraftory.advancements.skill.50.title"), (Component)Component.translatable((String)"runecraftory.advancements.skill.50.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("skill", SkillLevelTrigger.TriggerInstance.of(50)).save(cons, LibAdvancements.SKILL_50.toString());
            AdvancementHolder skill100 = Advancement.Builder.advancement().parent(skill50).display((ItemLike)Items.EXPERIENCE_BOTTLE, (Component)Component.translatable((String)"runecraftory.advancements.skill.100.title"), (Component)Component.translatable((String)"runecraftory.advancements.skill.100.description"), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("skill", SkillLevelTrigger.TriggerInstance.of(100)).save(cons, LibAdvancements.SKILL_100.toString());
            AdvancementHolder level10 = Advancement.Builder.advancement().parent(root).display((ItemLike)RuneCraftoryItems.LEVELISER.get(), (Component)Component.translatable((String)"runecraftory.advancements.level.10.title"), (Component)Component.translatable((String)"runecraftory.advancements.level.10.description"), null, AdvancementType.TASK, true, true, false).addCriterion("level", LevelTrigger.TriggerInstance.of(10)).save(cons, LibAdvancements.LEVEL_10.toString());
            AdvancementHolder level25 = Advancement.Builder.advancement().parent(level10).display((ItemLike)RuneCraftoryItems.LEVELISER.get(), (Component)Component.translatable((String)"runecraftory.advancements.level.25.title"), (Component)Component.translatable((String)"runecraftory.advancements.level.25.description"), null, AdvancementType.TASK, true, true, false).addCriterion("level", LevelTrigger.TriggerInstance.of(25)).save(cons, LibAdvancements.LEVEL_25.toString());
            AdvancementHolder level50 = Advancement.Builder.advancement().parent(level25).display(RunecraftoryAdvancements.glowing((ItemLike)RuneCraftoryItems.LEVELISER.get()), (Component)Component.translatable((String)"runecraftory.advancements.level.50.title"), (Component)Component.translatable((String)"runecraftory.advancements.level.50.description"), null, AdvancementType.TASK, true, true, false).addCriterion("level", LevelTrigger.TriggerInstance.of(50)).save(cons, LibAdvancements.LEVEL_50.toString());
            AdvancementHolder level100 = Advancement.Builder.advancement().parent(level50).display(RunecraftoryAdvancements.glowing((ItemLike)RuneCraftoryItems.LEVELISER.get()), (Component)Component.translatable((String)"runecraftory.advancements.level.100.title"), (Component)Component.translatable((String)"runecraftory.advancements.level.100.description"), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("level", LevelTrigger.TriggerInstance.of(100)).save(cons, LibAdvancements.LEVEL_100.toString());
            AdvancementHolder forgingItem = Advancement.Builder.advancement().parent(root).display((ItemLike)RuneCraftoryItems.FORGE.get(), (Component)Component.translatable((String)"runecraftory.advancements.crafting.forging.title"), (Component)Component.translatable((String)"runecraftory.advancements.crafting.forging.description"), null, AdvancementType.TASK, true, true, false).addCriterion("craft", ((PlayerTrigger)RuneCraftoryCriteria.FORGING.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(cons, LibAdvancements.FORGE_ITEM.toString());
            AdvancementHolder craftingItem = Advancement.Builder.advancement().parent(root).display((ItemLike)RuneCraftoryItems.ACCESSORY_WORKBENCH.get(), (Component)Component.translatable((String)"runecraftory.advancements.crafting.armor.title"), (Component)Component.translatable((String)"runecraftory.advancements.crafting.armor.description"), null, AdvancementType.TASK, true, true, false).addCriterion("craft", ((PlayerTrigger)RuneCraftoryCriteria.CRAFTING.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(cons, LibAdvancements.CRAFT_ARMOR.toString());
            AdvancementHolder brewingItem = Advancement.Builder.advancement().parent(root).display((ItemLike)RuneCraftoryItems.CHEMISTRY_SET.get(), (Component)Component.translatable((String)"runecraftory.advancements.crafting.chemistry.title"), (Component)Component.translatable((String)"runecraftory.advancements.crafting.chemistry.description"), null, AdvancementType.TASK, true, true, false).addCriterion("craft", ((PlayerTrigger)RuneCraftoryCriteria.MEDICINE.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(cons, LibAdvancements.MAKE_MEDICINE.toString());
            AdvancementHolder cookingItem = Advancement.Builder.advancement().parent(root).display((ItemLike)RuneCraftoryItems.COOKING_TABLE.get(), (Component)Component.translatable((String)"runecraftory.advancements.crafting.cooking.title"), (Component)Component.translatable((String)"runecraftory.advancements.crafting.cooking.description"), null, AdvancementType.TASK, true, true, false).addCriterion("craft", ((PlayerTrigger)RuneCraftoryCriteria.COOKING.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(cons, LibAdvancements.COOK.toString());
            AdvancementHolder upgradeItem = Advancement.Builder.advancement().parent(craftingItem).display((ItemLike)RuneCraftoryItems.CHEAP_BRACELET.get(), (Component)Component.translatable((String)"runecraftory.advancements.upgrade.title"), (Component)Component.translatable((String)"runecraftory.advancements.upgrade.description"), null, AdvancementType.TASK, true, true, false).addCriterion("upgrade", ((PlayerTrigger)RuneCraftoryCriteria.UPGRADE_ITEM.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(cons, LibAdvancements.UPGRADE_ITEM.toString());
            AdvancementHolder changeElement = Advancement.Builder.advancement().parent(forgingItem).display((ItemLike)RuneCraftoryItems.CRYSTAL_LOVE.get(), (Component)Component.translatable((String)"runecraftory.advancements.change.element.title"), (Component)Component.translatable((String)"runecraftory.advancements.change.element.description"), null, AdvancementType.TASK, true, true, false).addCriterion("element", ((PlayerTrigger)RuneCraftoryCriteria.CHANGE_ELEMENT.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(cons, LibAdvancements.CHANGE_ELEMENT.toString());
            AdvancementHolder lightOre = Advancement.Builder.advancement().parent(changeElement).display((ItemLike)RuneCraftoryItems.LIGHT_ORE.get(), (Component)Component.translatable((String)"runecraftory.advancements.lightore.title"), (Component)Component.translatable((String)"runecraftory.advancements.lightore.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("light_ore", ((PlayerTrigger)RuneCraftoryCriteria.LIGHT_ORE.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(cons, LibAdvancements.LIGHT_ORE.toString());
            AdvancementHolder spell = Advancement.Builder.advancement().parent(forgingItem).display((ItemLike)RuneCraftoryItems.FIRE_BALL_SMALL.get(), (Component)Component.translatable((String)"runecraftory.advancements.spell.title"), (Component)Component.translatable((String)"runecraftory.advancements.spell.description"), null, AdvancementType.TASK, true, true, false).addCriterion("spell", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(RunecraftoryTags.Items.SPELLS).build()})).save(cons, LibAdvancements.SPELL.toString());
            AdvancementHolder changeSpell = Advancement.Builder.advancement().parent(forgingItem).display((ItemLike)RuneCraftoryItems.ROD.get(), (Component)Component.translatable((String)"runecraftory.advancements.change.spell.title"), (Component)Component.translatable((String)"runecraftory.advancements.change.spell.description"), null, AdvancementType.TASK, true, true, false).addCriterion("spell", ((PlayerTrigger)RuneCraftoryCriteria.CHANGE_SPELL.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(cons, LibAdvancements.CHANGE_SPELL.toString());
            AdvancementHolder fertilizer = Advancement.Builder.advancement().parent(root).display((ItemLike)RuneCraftoryItems.FORMULAR_A.get(), (Component)Component.translatable((String)"runecraftory.advancements.fertilizer.title"), (Component)Component.translatable((String)"runecraftory.advancements.fertilizer.description"), null, AdvancementType.TASK, true, true, false).addCriterion("fertilizer", ((PlayerTrigger)RuneCraftoryCriteria.FERTILIZE_FARM.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(cons, LibAdvancements.FERTILIZER.toString());
            AdvancementHolder giantCrop = Advancement.Builder.advancement().parent(fertilizer).display((ItemLike)RuneCraftoryItems.TURNIP_GIANT.get(), (Component)Component.translatable((String)"runecraftory.advancements.giant_crop.title"), (Component)Component.translatable((String)"runecraftory.advancements.giant_crop.description"), null, AdvancementType.GOAL, true, true, false).addCriterion("giant_crop", CropHarvestTrigger.TriggerInstance.harvest(RunecraftoryTags.Blocks.GIANT_CROP_BLOCKS)).save(cons, LibAdvancements.GIANT_CROPS.toString());
            AdvancementHolder helper = Advancement.Builder.advancement().parent(fertilizer).display((ItemLike)RuneCraftoryItems.MOB_STAFF.get(), (Component)Component.translatable((String)"runecraftory.advancements.monster.help.title"), (Component)Component.translatable((String)"runecraftory.advancements.monster.help.description"), null, AdvancementType.TASK, true, true, false).addCriterion("farming", ((PlayerTrigger)RuneCraftoryCriteria.COMMAND_FARMING.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(cons, LibAdvancements.HELPER.toString());
            AdvancementHolder hightTierTool = Advancement.Builder.advancement().parent(helper).display((ItemLike)RuneCraftoryItems.WATERING_CAN_PLATINUM.get(), (Component)Component.translatable((String)"runecraftory.advancements.final.tool.title"), (Component)Component.translatable((String)"runecraftory.advancements.final.tool.description"), null, AdvancementType.CHALLENGE, true, true, false).addCriterion("final_tool", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(RunecraftoryTags.Items.HIGH_TIER_TOOLS).build()})).save(cons, LibAdvancements.HIGH_TIER_TOOL.toString());
            AdvancementHolder rootProgression = Advancement.Builder.advancement().display((ItemLike)RuneCraftoryItems.SHORT_DAGGER.get(), (Component)Component.translatable((String)"runecraftory.advancements.progression.root.title"), (Component)Component.translatable((String)"runecraftory.advancements.progression.root.description"), ResourceLocation.withDefaultNamespace((String)"textures/block/dirt.png"), AdvancementType.TASK, false, false, false).addCriterion("crafting_table", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Blocks.CRAFTING_TABLE})).save(cons, LibAdvancements.ROOT_PROGRESSION.toString());
            Advancement.Builder builder = Advancement.Builder.advancement().display((ItemLike)SpawnEgg.fromType((EntityType)((EntityType)RuneCraftoryEntities.WOOLY.get())).get(), (Component)Component.translatable((String)"runecraftory.advancements.progression.boss.greater_demon.title"), (Component)Component.translatable((String)"runecraftory.advancements.progression.boss.greater_demon.description"), ResourceLocation.withDefaultNamespace((String)"textures/block/dirt.png"), AdvancementType.TASK, true, true, false).addCriterion("dummy", CriteriaTriggers.IMPOSSIBLE.createCriterion((CriterionTriggerInstance)new ImpossibleTrigger.TriggerInstance()));
            AdvancementHolder greater_demon = builder.save(cons, LibAdvancements.GREATER_DEMON.toString());
            AdvancementHolder chimera = RunecraftoryAdvancements.bossProgression(RuneCraftoryEntities.CHIMERA, cons, LibAdvancements.CHIMERA, greater_demon);
            AdvancementHolder rafflesia = RunecraftoryAdvancements.bossProgression(RuneCraftoryEntities.RAFFLESIA, cons, LibAdvancements.RAFFLESIA, chimera);
            AdvancementHolder grimoire = RunecraftoryAdvancements.bossProgression(RuneCraftoryEntities.GRIMOIRE, cons, LibAdvancements.GRIMOIRE, rafflesia);
            AdvancementHolder deadTree = RunecraftoryAdvancements.bossProgression(RuneCraftoryEntities.DEAD_TREE, cons, LibAdvancements.DEAD_TREE, rootProgression);
            AdvancementHolder raccoon = RunecraftoryAdvancements.bossProgression(RuneCraftoryEntities.RACCOON, cons, LibAdvancements.RACCOON, rootProgression);
            AdvancementHolder skelefang = RunecraftoryAdvancements.bossProgression(RuneCraftoryEntities.SKELEFANG, cons, LibAdvancements.SKELEFANG, raccoon);
            AdvancementHolder ambrosia = RunecraftoryAdvancements.bossProgression(RuneCraftoryEntities.AMBROSIA, cons, LibAdvancements.AMBROSIA, rootProgression);
            AdvancementHolder thunderbolt = RunecraftoryAdvancements.bossProgression(RuneCraftoryEntities.THUNDERBOLT, cons, LibAdvancements.THUNDERBOLT, ambrosia);
            AdvancementHolder marionetta = RunecraftoryAdvancements.bossProgression(RuneCraftoryEntities.MARIONETTA, cons, LibAdvancements.MARIONETTA, thunderbolt);
            AdvancementHolder handonetta = RunecraftoryAdvancements.bossProgression(RuneCraftoryEntities.HANDONETTA, cons, LibAdvancements.HANDONETTA, thunderbolt);
            builder = Advancement.Builder.advancement().display((ItemLike)SpawnEgg.fromType((EntityType)((EntityType)RuneCraftoryEntities.SANO.get())).get(), (Component)Component.translatable((String)"runecraftory.advancements.progression.boss.sano_uno.title"), (Component)Component.translatable((String)"runecraftory.advancements.progression.boss.sano_uno.description"), ResourceLocation.withDefaultNamespace((String)"textures/block/dirt.png"), AdvancementType.TASK, true, true, false).addCriterion("boss1", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)RuneCraftoryEntities.SANO.get()), (DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().source(LibAdvancements.playerAdvancementCheck(marionetta.id())))).addCriterion("boss2", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)RuneCraftoryEntities.UNO.get()), (DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().source(LibAdvancements.playerAdvancementCheck(marionetta.id())))).parent(marionetta);
            AdvancementHolder sano_uno = builder.save(cons, LibAdvancements.SANO_UNO.toString());
            AdvancementHolder sarcophagus = RunecraftoryAdvancements.bossProgression(RuneCraftoryEntities.SARCOPHAGUS, cons, LibAdvancements.SARCOPHAGUS, sano_uno);
        }

        private static ItemStack glowing(ItemLike itemLike) {
            ItemStack stack = new ItemStack((ItemLike)itemLike.asItem());
            stack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
            return stack;
        }

        protected static Advancement.Builder allBosses(Advancement.Builder builder) {
            for (RegistryEntrySupplier<EntityType<?>, EntityType<?>> sup : RuneCraftoryEntities.getBosses()) {
                builder.addCriterion(sup.getID().toString(), TameMonsterTrigger.TriggerInstance.of(1, new EntityPredicate.Builder().of((EntityType)sup.get())));
            }
            return builder;
        }

        private static AdvancementHolder bossProgression(RegistryEntrySupplier<EntityType<?>, ?> entity, Consumer<AdvancementHolder> cons, ResourceLocation id, AdvancementHolder parent) {
            return RunecraftoryAdvancements.bossProgression(entity, cons, id, parent, false);
        }

        private static AdvancementHolder bossProgression(RegistryEntrySupplier<EntityType<?>, ?> entity, Consumer<AdvancementHolder> cons, ResourceLocation id, AdvancementHolder parent, boolean hidden) {
            Criterion trigger = parent != null ? KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)entity.get()), (DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().source(LibAdvancements.playerAdvancementCheck(parent.id()))) : KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of((EntityType)entity.get()));
            Advancement.Builder builder = Advancement.Builder.advancement().display((ItemLike)SpawnEgg.fromType((EntityType)((EntityType)entity.get())).get(), (Component)Component.translatable((String)String.format("runecraftory.advancements.progression.boss.%s.title", entity.getID().getPath())), (Component)Component.translatable((String)String.format("runecraftory.advancements.progression.boss.%s.description", entity.getID().getPath())), ResourceLocation.withDefaultNamespace((String)"textures/block/dirt.png"), AdvancementType.TASK, true, true, hidden).addCriterion("boss", trigger);
            if (parent != null) {
                builder.parent(parent);
            }
            return builder.save(cons, id.toString());
        }
    }
}

