/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class CropProperties {
    public static final Codec<CropProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CropMappingInfo.CODEC.fieldOf("crop").forGetter(CropProperties::getInfo), (App)Codec.INT.fieldOf("growth").forGetter(CropProperties::growth), (App)Codec.INT.fieldOf("max_drops").forGetter(CropProperties::maxDrops), (App)Codec.BOOL.fieldOf("regrowable").forGetter(CropProperties::regrowable), (App)CodecUtils.stringEnumCodec(Season.class, (Enum)Season.SPRING).listOf().fieldOf("best_season").forGetter(d -> List.copyOf(d.bestSeasons)), (App)CodecUtils.stringEnumCodec(Season.class, (Enum)Season.SPRING).listOf().fieldOf("bad_season").forGetter(d -> List.copyOf(d.badSeasons))).apply((Applicative)instance, CropProperties::new));
    public static final class_9139<class_9129, CropProperties> STREAM_CODEC = new class_9139<class_9129, CropProperties>(){

        public CropProperties decode(class_9129 buf) {
            return new CropProperties(CropMappingInfo.EMPTY, buf.readInt(), buf.readInt(), buf.readBoolean(), buf.method_46251(Season.class), buf.method_46251(Season.class));
        }

        public void encode(class_9129 buf, CropProperties props) {
            buf.method_53002(props.growth());
            buf.method_53002(props.maxDrops());
            buf.method_52964(props.regrowable());
            buf.method_46253(props.bestSeasons, Season.class);
            buf.method_46253(props.badSeasons, Season.class);
        }
    };
    private final CropMappingInfo info;
    private final EnumSet<Season> bestSeasons;
    private final EnumSet<Season> badSeasons;
    private final int growth;
    private final int maxDrops;
    private final boolean regrowable;
    private final List<class_2561> translationTexts;

    public CropProperties(CropMappingInfo info, int growth, int maxDrops, boolean regrowable, Collection<Season> badSeasons, Collection<Season> bestSeasons) {
        this.info = info;
        this.growth = growth;
        this.maxDrops = maxDrops;
        this.regrowable = regrowable;
        this.bestSeasons = bestSeasons.isEmpty() ? EnumSet.noneOf(Season.class) : EnumSet.copyOf(bestSeasons);
        this.badSeasons = badSeasons.isEmpty() ? EnumSet.noneOf(Season.class) : EnumSet.copyOf(badSeasons);
        this.translationTexts = this.generateText();
    }

    private List<class_2561> generateText() {
        ImmutableList.Builder list = ImmutableList.builder();
        if (!this.bestSeasons.isEmpty()) {
            class_5250 txt = null;
            for (Season season : this.bestSeasons) {
                if (txt == null) {
                    txt = class_2561.method_43471((String)season.translationKey()).method_27692(season.getColor());
                    continue;
                }
                txt.method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43471((String)season.translationKey()).method_27692(season.getColor()));
            }
            list.add((Object)class_2561.method_43469((String)"runecraftory.tooltip.crops.season.best", (Object[])new Object[]{txt}).method_27692(class_124.field_1080));
        }
        EnumSet<Season> badSeasons = EnumSet.copyOf(this.badSeasons);
        badSeasons.removeAll(this.bestSeasons);
        if (!badSeasons.isEmpty()) {
            class_5250 txt = null;
            for (Season season : badSeasons) {
                if (txt == null) {
                    txt = class_2561.method_43471((String)season.translationKey()).method_27692(season.getColor());
                    continue;
                }
                txt.method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43471((String)season.translationKey()).method_27692(season.getColor()));
            }
            list.add((Object)class_2561.method_43469((String)"runecraftory.tooltip.crops.season.bad", (Object[])new Object[]{txt}).method_27692(class_124.field_1080));
        }
        class_5250 growth = class_2561.method_43469((String)"runecraftory.tooltip.crops.growth", (Object[])new Object[]{this.growth()}).method_27692(class_124.field_1065);
        class_5250 class_52502 = class_2561.method_43469((String)"runecraftory.tooltip.crops.harvested", (Object[])new Object[]{this.maxDrops()}).method_27692(class_124.field_1065);
        if (this.regrowable()) {
            class_5250 regrowable = class_2561.method_43471((String)"runecraftory.tooltip.crops.regrowable").method_27692(class_124.field_1060);
            list.add((Object)class_2561.method_43469((String)"runecraftory.tooltip.crops.entry.3", (Object[])new Object[]{growth, class_52502, regrowable}));
        } else {
            list.add((Object)class_2561.method_43469((String)"runecraftory.tooltip.crops.entry.2", (Object[])new Object[]{growth, class_52502}));
        }
        return list.build();
    }

    public CropMappingInfo getInfo() {
        return this.info;
    }

    public int growth() {
        return this.growth;
    }

    public int maxDrops() {
        return this.maxDrops;
    }

    public boolean regrowable() {
        return this.regrowable;
    }

    public Optional<class_2248> getGiantVersion() {
        return this.info.giant.map(Pair::getSecond);
    }

    public float seasonMultiplier(Season season) {
        if (this.bestSeasons.contains((Object)season)) {
            return 1.5f;
        }
        if (this.badSeasons.contains((Object)season)) {
            return 0.6666667f;
        }
        return 1.0f;
    }

    public List<class_2561> texts() {
        return this.translationTexts;
    }

    public String toString() {
        return "[BestSeasons:" + String.valueOf(this.bestSeasons) + ";BadSeasons:" + String.valueOf(this.badSeasons) + ";Growth:" + this.growth + ";Drops:" + this.maxDrops + ";Regrowable:" + this.regrowable + "]";
    }

    public record CropMappingInfo(class_6885<class_1792> seed, class_6885<class_1792> crop, class_6885<class_2248> cropBlock, Optional<Pair<class_1792, class_2248>> giant) {
        public static final Codec<CropMappingInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6895.method_40340((class_5321)class_7924.field_41197).fieldOf("seed").forGetter(CropMappingInfo::seed), (App)class_6895.method_40340((class_5321)class_7924.field_41197).fieldOf("crop").forGetter(CropMappingInfo::crop), (App)class_6895.method_40340((class_5321)class_7924.field_41254).fieldOf("crop_block").forGetter(CropMappingInfo::cropBlock), (App)Codec.mapPair((MapCodec)class_7923.field_41178.method_39673().fieldOf("item"), (MapCodec)class_7923.field_41175.method_39673().fieldOf("block")).codec().optionalFieldOf("giant_crop").forGetter(CropMappingInfo::giant)).apply((Applicative)instance, CropMappingInfo::new));
        public static final CropMappingInfo EMPTY = new CropMappingInfo((class_6885<class_1792>)class_6885.method_58563(), (class_6885<class_1792>)class_6885.method_58563(), (class_6885<class_2248>)class_6885.method_58563(), Optional.empty());

        public CropMappingInfo(class_6885<class_1792> seed, class_6885<class_1792> crop, class_6885<class_2248> cropBlock) {
            this(seed, crop, cropBlock, Optional.empty());
        }
    }

    public static class Builder {
        private final EnumSet<Season> bestSeason = EnumSet.noneOf(Season.class);
        private final EnumSet<Season> badSeason = EnumSet.noneOf(Season.class);
        private final CropMappingInfo info;
        private final int growth;
        private final int maxDrops;
        private final boolean regrowable;

        public Builder(class_6880<class_1792> seed, class_6880<class_1792> crop, class_6880<class_2248> cropBlock, int growth, int maxDrops, boolean regrowable) {
            this((class_6885<class_1792>)class_6885.method_40246((class_6880[])new class_6880[]{seed}), (class_6885<class_1792>)class_6885.method_40246((class_6880[])new class_6880[]{crop}), (class_6885<class_2248>)class_6885.method_40246((class_6880[])new class_6880[]{cropBlock}), growth, maxDrops, regrowable);
        }

        public Builder(class_6880<class_1792> seed, class_6880<class_1792> crop, class_6880<class_2248> cropBlock, Pair<class_1792, class_2248> giant, int growth, int maxDrops, boolean regrowable) {
            this((class_6885<class_1792>)class_6885.method_40246((class_6880[])new class_6880[]{seed}), (class_6885<class_1792>)class_6885.method_40246((class_6880[])new class_6880[]{crop}), (class_6885<class_2248>)class_6885.method_40246((class_6880[])new class_6880[]{cropBlock}), giant, growth, maxDrops, regrowable);
        }

        public Builder(class_6885<class_1792> seed, class_6885<class_1792> crop, class_6885<class_2248> cropBlock, int growth, int maxDrops, boolean regrowable) {
            this.info = new CropMappingInfo(seed, crop, cropBlock);
            this.growth = growth;
            this.maxDrops = maxDrops;
            this.regrowable = regrowable;
        }

        public Builder(class_6885<class_1792> seed, class_6885<class_1792> crop, class_6885<class_2248> cropBlock, Pair<class_1792, class_2248> giant, int growth, int maxDrops, boolean regrowable) {
            this.info = new CropMappingInfo(seed, crop, cropBlock, Optional.of(giant));
            this.growth = growth;
            this.maxDrops = maxDrops;
            this.regrowable = regrowable;
        }

        public Builder addGoodSeason(Season season) {
            this.bestSeason.add(season);
            return this;
        }

        public Builder addBadSeason(Season season) {
            this.badSeason.add(season);
            return this;
        }

        public class_2960 tryGetId() {
            return (class_2960)this.info.seed.method_40248().map(class_6862::comp_327, l -> {
                if (l.isEmpty()) {
                    throw new IllegalStateException("Empty holderset. This is not allowed");
                }
                return ((class_5321)((class_6880)l.getFirst()).method_40230().orElseThrow()).method_29177();
            });
        }

        public CropProperties build() {
            return new CropProperties(this.info, this.growth, this.maxDrops, this.regrowable, this.bestSeason, this.badSeason);
        }
    }
}

