/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.EntityRideActionCosts;
import io.github.flemmli97.tenshilib.common.utils.SearchUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1320;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class EntityProperties {
    public static final EntityProperties DEFAULT_PROP = new Builder().putAttributes((class_6880<class_1320>)class_5134.field_23716, 20.0).putAttributes((class_6880<class_1320>)class_5134.field_23721, 1.0).xp(5).money(5).tamingChance(0.3f).build();
    public static final Codec<EntityProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33442.fieldOf("min_level").forGetter(d -> d.minLevel), (App)class_5699.field_33441.fieldOf("xp").forGetter(d -> d.xp), (App)class_5699.field_33441.fieldOf("money").forGetter(d -> d.money), (App)Codec.FLOAT.fieldOf("taming_chance").forGetter(d -> Float.valueOf(d.tamingChance)), (App)Codec.BOOL.fieldOf("rideable").forGetter(d -> d.rideable), (App)Codec.BOOL.fieldOf("flying").forGetter(d -> d.flying), (App)class_5699.field_33442.fieldOf("size").forGetter(d -> d.size), (App)Codec.BOOL.fieldOf("needs_roof").forGetter(d -> d.needsRoof), (App)EntityRideActionCosts.CODEC.fieldOf("ride_action_costs").forGetter(d -> d.rideActionCosts), (App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("base_values").forGetter(d -> d.baseValues), (App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("level_gains").forGetter(d -> d.levelGains), (App)OnKilledIncrease.CODEC.listOf().optionalFieldOf("level_increase_on_kill").forGetter(d -> d.levelIncreaseOnKill.isEmpty() ? Optional.empty() : Optional.of(d.levelIncreaseOnKill)), (App)class_2048.field_45746.optionalFieldOf("spawner_predicate").forGetter(EntityProperties::spawnerPredicate)).apply((Applicative)instance, (minLevel, xp, money, tamingChance, rideable, flying, size, needsRoof, rideActionCosts, baseValues, levelGains, levelIncreaseOnKill, spawnerPredicate) -> new EntityProperties((int)minLevel, (int)xp, (int)money, tamingChance.floatValue(), (boolean)rideable, (boolean)flying, (int)size, (boolean)needsRoof, (EntityRideActionCosts)rideActionCosts, (Map<class_6880<class_1320>, Double>)baseValues, (Map<class_6880<class_1320>, Double>)levelGains, levelIncreaseOnKill.orElse(List.of()), (Optional<class_2048>)spawnerPredicate)));
    public final int minLevel;
    public final int xp;
    public final int money;
    public final float tamingChance;
    public final boolean rideable;
    public final boolean flying;
    public final int size;
    public final boolean needsRoof;
    public final EntityRideActionCosts rideActionCosts;
    private final Map<class_6880<class_1320>, Double> baseValues;
    private final Map<class_6880<class_1320>, Double> levelGains;
    private final List<OnKilledIncrease> levelIncreaseOnKill;
    private final class_2048 spawnerPredicate;

    private EntityProperties(int minLevel, int xp, int money, float tamingChance, boolean rideable, boolean flying, int size, boolean needsRoof, EntityRideActionCosts rideActionCosts, Map<class_6880<class_1320>, Double> baseValues, Map<class_6880<class_1320>, Double> levelGains, List<OnKilledIncrease> levelIncreaseOnKill, Optional<class_2048> spawnerPredicate) {
        this.minLevel = Math.max(1, minLevel);
        this.xp = xp;
        this.money = money;
        this.tamingChance = tamingChance;
        this.rideable = rideable;
        this.flying = flying;
        this.size = size;
        this.needsRoof = needsRoof;
        this.rideActionCosts = rideActionCosts;
        this.baseValues = ImmutableMap.copyOf(baseValues);
        this.levelGains = ImmutableMap.copyOf(levelGains);
        this.levelIncreaseOnKill = levelIncreaseOnKill.stream().sorted().toList();
        this.spawnerPredicate = spawnerPredicate.orElse(null);
    }

    public Map<class_6880<class_1320>, Double> baseValues() {
        return this.baseValues;
    }

    public Map<class_6880<class_1320>, Double> levelGains() {
        return this.levelGains;
    }

    public Optional<class_2048> spawnerPredicate() {
        return Optional.ofNullable(this.spawnerPredicate);
    }

    public int levelIncreaseFromKill(int killed, class_3222 player) {
        return ((OnKilledIncrease)SearchUtils.searchInfFunc(this.levelIncreaseOnKill.stream().filter(c -> c.condition.map(cond -> cond.method_8914(player, (class_1297)player)).orElse(false)).toList(), p -> Integer.compare(p.minKilled(), killed), (Object)OnKilledIncrease.DEFAULT)).increase();
    }

    private record OnKilledIncrease(int minKilled, int increase, Optional<class_2048> condition) implements Comparable<OnKilledIncrease>
    {
        private static final OnKilledIncrease DEFAULT = new OnKilledIncrease(0, 0, null);
        public static final Codec<OnKilledIncrease> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("min_killed").forGetter(d -> d.minKilled), (App)Codec.INT.fieldOf("increase").forGetter(d -> d.increase), (App)class_2048.field_45746.optionalFieldOf("predicate").forGetter(d -> d.condition)).apply((Applicative)inst, OnKilledIncrease::new));

        @Override
        public int compareTo(@NotNull OnKilledIncrease o) {
            return Integer.compare(this.minKilled, o.minKilled);
        }
    }

    public static class Builder {
        private final Map<class_6880<class_1320>, Double> baseValues = new LinkedHashMap<class_6880<class_1320>, Double>();
        private final Map<class_6880<class_1320>, Double> gains = new LinkedHashMap<class_6880<class_1320>, Double>();
        private int xp;
        private int money;
        private float taming;
        private boolean rideable;
        private boolean flying;
        private int size = 1;
        private boolean needsRoof = true;
        private int minLevel = 1;
        private EntityRideActionCosts rideActionCosts = EntityRideActionCosts.DEFAULT;
        private final List<OnKilledIncrease> levelIncreaseOnKill = new ArrayList<OnKilledIncrease>();
        private class_2048 spawnerPredicate;

        public Builder putAttributes(class_6880<class_1320> att, double val) {
            this.baseValues.put(att, val);
            return this;
        }

        public Builder putLevelGains(class_6880<class_1320> att, double val) {
            this.gains.put(att, val);
            return this;
        }

        public Builder xp(int xp) {
            this.xp = xp;
            return this;
        }

        public Builder money(int money) {
            this.money = money;
            return this;
        }

        public Builder tamingChance(float chance) {
            this.taming = chance;
            return this;
        }

        public Builder setRideable() {
            this.rideable = true;
            return this;
        }

        public Builder setFlying() {
            this.flying = true;
            return this;
        }

        public Builder setBarnOccupancy(int size) {
            this.size = Math.max(1, size);
            return this;
        }

        public Builder doesntNeedBarnRoof() {
            this.needsRoof = false;
            return this;
        }

        public Builder setMinLevel(int minLevel) {
            this.minLevel = minLevel;
            return this;
        }

        public Builder withLevelIncrease(int minKilled, int increase) {
            this.levelIncreaseOnKill.add(new OnKilledIncrease(minKilled, increase, Optional.empty()));
            return this;
        }

        public Builder withLevelIncrease(int minKilled, int increase, class_2048.class_2049 pred) {
            this.levelIncreaseOnKill.add(new OnKilledIncrease(minKilled, increase, Optional.of(pred.method_8920())));
            return this;
        }

        public Builder withRideActionCosts(EntityRideActionCosts.Builder costs) {
            this.rideActionCosts = costs.build();
            return this;
        }

        public Builder withSpawnerPredicate(class_2048.class_2049 builder) {
            this.spawnerPredicate = builder.method_8920();
            return this;
        }

        public EntityProperties build() {
            return new EntityProperties(this.minLevel, this.xp, this.money, this.taming, this.rideable, this.flying, this.size, this.needsRoof, this.rideActionCosts, this.baseValues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)), this.gains.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new)), this.levelIncreaseOnKill, Optional.ofNullable(this.spawnerPredicate));
        }
    }
}

