/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.ArmorEffect;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryArmorEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.StreamCodecUtils;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import io.github.flemmli97.tenshilib.common.utils.MapUtils;
import it.unimi.dsi.fastutil.objects.Object2DoubleAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleSortedMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleSortedMaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9285;

public class ItemStat {
    public static boolean SHOW_STATS_CUSTOM = true;
    public static final Codec<ItemStat> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuneCraftorySpells.SPELLS.registry().method_40294().optionalFieldOf("tier_3_Spell").forGetter(ItemStat::getTier3Spell), (App)RuneCraftoryArmorEffects.ARMOR_EFFECTS.registry().method_40294().optionalFieldOf("armor_effect").forGetter(ItemStat::getArmorEffect), (App)CodecUtils.stringEnumCodec(ItemElement.class, (Enum)ItemElement.NONE).orElse((Object)ItemElement.NONE).fieldOf("element").forGetter(ItemStat::element), (App)RuneCraftorySpells.SPELLS.registry().method_40294().optionalFieldOf("tier_1_Spell").forGetter(ItemStat::getTier1Spell), (App)RuneCraftorySpells.SPELLS.registry().method_40294().optionalFieldOf("tier_2_Spell").forGetter(ItemStat::getTier2Spell), (App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("item_stats").forGetter(ItemStat::itemStats), (App)Codec.unboundedMap((Codec)class_7923.field_41190.method_40294(), (Codec)Codec.DOUBLE).fieldOf("monster_bonus").forGetter(ItemStat::getMonsterGiftIncrease), (App)class_5699.field_33441.fieldOf("buy_price").forGetter(ItemStat::getBuy), (App)class_5699.field_33441.fieldOf("sell_price").forGetter(ItemStat::getSell), (App)class_5699.field_33441.fieldOf("upgrade_difficulty").forGetter(ItemStat::getDiff)).apply((Applicative)instance, (spell3, armorEffect, element, spell, spell2, atts, monster, buy, sell, upgrade) -> new ItemStat((int)buy, (int)sell, (int)upgrade, (ItemElement)((Object)((Object)element)), (Optional<class_6880<Spell>>)spell, (Optional<class_6880<Spell>>)spell2, (Optional<class_6880<Spell>>)spell3, (Optional<class_6880<ArmorEffect>>)armorEffect, (Map<class_6880<class_1320>, Double>)atts, (Map<class_6880<class_1320>, Double>)monster)));
    public static final class_9139<class_9129, ItemStat> STREAM_CODEC = new class_9139<class_9129, ItemStat>(){
        private static final class_9139<class_9129, Optional<class_6880<Spell>>> SPELL_CODEC = class_9135.method_56382((class_9139)class_9135.method_56383(RuneCraftorySpells.SPELL_REGISTRY_KEY));

        public ItemStat decode(class_9129 buf) {
            return new ItemStat(buf.readInt(), buf.readInt(), buf.readInt(), (ItemElement)buf.method_10818(ItemElement.class), (Optional)SPELL_CODEC.decode((Object)buf), (Optional)SPELL_CODEC.decode((Object)buf), (Optional)SPELL_CODEC.decode((Object)buf), (Optional)class_9135.method_56382((class_9139)class_9135.method_56383(RuneCraftoryArmorEffects.ARMOR_EFFECT_KEY)).decode((Object)buf), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf), (Map)StreamCodecUtils.ATTRIBUTE_CODEC.decode((Object)buf));
        }

        public void encode(class_9129 buf, ItemStat prop) {
            buf.method_53002(prop.buyPrice);
            buf.method_53002(prop.sellPrice);
            buf.method_53002(prop.upgradeDifficulty);
            buf.method_10817((Enum)prop.element);
            SPELL_CODEC.encode((Object)buf, prop.getTier2Spell());
            SPELL_CODEC.encode((Object)buf, prop.getTier2Spell());
            SPELL_CODEC.encode((Object)buf, prop.getTier2Spell());
            class_9135.method_56382((class_9139)class_9135.method_56383(RuneCraftoryArmorEffects.ARMOR_EFFECT_KEY)).encode((Object)buf, prop.getArmorEffect());
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, prop.itemStats);
            StreamCodecUtils.ATTRIBUTE_CODEC.encode((Object)buf, prop.monsterGiftIncrease);
        }
    };
    private final int buyPrice;
    private final int sellPrice;
    private final int upgradeDifficulty;
    private final ItemElement element;
    private final Optional<class_6880<Spell>> tier1Spell;
    private final Optional<class_6880<Spell>> tier2Spell;
    private final Optional<class_6880<Spell>> tier3Spell;
    private final Optional<class_6880<ArmorEffect>> armorEffect;
    private final Map<class_6880<class_1320>, Double> itemStats;
    private final Map<class_6880<class_1320>, Double> monsterGiftIncrease;

    private ItemStat(int buyPrice, int sellPrice, int upgradeDifficulty, ItemElement element, Optional<class_6880<Spell>> tier1Spell, Optional<class_6880<Spell>> tier2Spell, Optional<class_6880<Spell>> tier3Spell, Optional<class_6880<ArmorEffect>> effect, Map<class_6880<class_1320>, Double> itemStats, Map<class_6880<class_1320>, Double> monsterGiftIncrease) {
        this.itemStats = ItemStat.createFor(itemStats);
        this.buyPrice = buyPrice;
        this.sellPrice = sellPrice;
        this.upgradeDifficulty = upgradeDifficulty;
        this.element = element;
        this.tier1Spell = tier1Spell;
        this.tier2Spell = tier2Spell;
        this.tier3Spell = tier3Spell;
        this.armorEffect = effect;
        this.monsterGiftIncrease = ItemStat.createFor(monsterGiftIncrease);
    }

    private static Map<class_6880<class_1320>, Double> createFor(Map<class_6880<class_1320>, Double> map) {
        Object2DoubleAVLTreeMap sorted = new Object2DoubleAVLTreeMap(RuneCraftoryAttributes.SORTED);
        sorted.putAll(map);
        return Object2DoubleSortedMaps.unmodifiable((Object2DoubleSortedMap)sorted);
    }

    public static class_1322 adjustModifier(class_6880<class_1320> attribute, class_1322 original) {
        if (attribute.method_40220(RunecraftoryTags.Attributes.PERCENTAGE_DISPLAY) && original.comp_2450() == class_1322.class_1323.field_6328) {
            return new class_1322(original.comp_2447(), original.comp_2449() * 0.01, class_1322.class_1323.field_6330);
        }
        return original;
    }

    public int getBuy() {
        return this.buyPrice;
    }

    public int getSell() {
        return this.sellPrice;
    }

    public int getDiff() {
        return this.upgradeDifficulty;
    }

    public ItemElement element() {
        return this.element;
    }

    public Map<class_6880<class_1320>, Double> itemStats() {
        TreeMap<class_6880<class_1320>, Double> map = new TreeMap<class_6880<class_1320>, Double>(RuneCraftoryAttributes.SORTED);
        map.putAll(this.itemStats);
        return map;
    }

    public Map<class_6880<class_1320>, Double> getMonsterGiftIncrease() {
        return this.monsterGiftIncrease;
    }

    public Optional<class_6880<Spell>> getTier1Spell() {
        return this.tier1Spell;
    }

    public Optional<class_6880<Spell>> getTier2Spell() {
        return this.tier2Spell;
    }

    public Optional<class_6880<Spell>> getTier3Spell() {
        return this.tier3Spell;
    }

    public Optional<class_6880<ArmorEffect>> getArmorEffect() {
        return this.armorEffect;
    }

    public List<class_2561> texts(class_1799 stack, boolean showStat) {
        boolean shouldHaveStats;
        int sellPrice;
        int buyPrice;
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        ArrayList<class_5250> header = new ArrayList<class_5250>();
        if (ItemComponentUtils.shouldHaveLevel(stack)) {
            header.add(class_2561.method_43469((String)"runecraftory.tooltip.item.level", (Object[])new Object[]{ItemComponentUtils.itemLevel(stack)}));
        }
        if ((buyPrice = ItemUtils.getBuyPrice(stack, this)) > 0) {
            header.add(class_2561.method_43469((String)"runecraftory.tooltip.item.buy", (Object[])new Object[]{buyPrice}));
        }
        if ((sellPrice = ItemUtils.getSellPrice(stack, this)) > 0) {
            header.add(class_2561.method_43469((String)"runecraftory.tooltip.item.sell", (Object[])new Object[]{sellPrice}));
        }
        if (!header.isEmpty()) {
            list.add((class_2561)class_2564.method_36332(header, (class_2561)class_5244.method_48320(), Function.identity()).method_27692(class_124.field_1054));
        }
        if (!(shouldHaveStats = ItemComponentUtils.shouldHaveStats(stack)) && this.getDiff() > 0) {
            list.add((class_2561)class_2561.method_43469((String)"runecraftory.tooltip.item.difficulty", (Object[])new Object[]{this.getDiff()}).method_27692(class_124.field_1054));
        }
        if (showStat && !shouldHaveStats) {
            Map stats = DataPackHandler.INSTANCE.itemStatManager().get(stack.method_7909()).map(ItemStat::itemStats).orElse(null);
            ItemStat.addUpgradeStatsText(stats, list);
        }
        return list;
    }

    private static void addUpgradeStatsText(Map<class_6880<class_1320>, Double> stats, List<class_2561> tooltip) {
        if (stats == null || stats.isEmpty()) {
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"runecraftory.tooltip.item.upgrade").method_27692(class_124.field_1080));
        for (Map.Entry<class_6880<class_1320>, Double> entry : stats.entrySet()) {
            if (entry.getKey().method_40220(RunecraftoryTags.Attributes.DISPLAY_IGNORED)) continue;
            double d = class_5134.field_23718.method_55838(entry.getKey()) ? entry.getValue() * 10.0 : entry.getValue();
            String num = ItemStat.format(entry.getKey(), d);
            if (num == null) continue;
            class_5250 comp = class_5244.method_48320().method_10852((class_2561)class_2561.method_43469((String)"runecraftory.tooltip.item.attribute", (Object[])new Object[]{class_2561.method_43471((String)((class_1320)entry.getKey().comp_349()).method_26830()), num}));
            tooltip.add((class_2561)comp.method_27692(class_124.field_1078));
        }
    }

    private static String format(class_6880<class_1320> att, double n) {
        String sign;
        String string = sign = n > 0.0 ? "+" : "";
        if (att.comp_349() == class_5134.field_23719.comp_349()) {
            double val = (double)((int)(n * 100.0)) / 100.0;
            if (val == 0.0) {
                return null;
            }
            return sign + class_9285.field_49329.format(val);
        }
        boolean percSign = att.method_40220(RunecraftoryTags.Attributes.PERCENTAGE_DISPLAY);
        double val = (float)((int)(n * 2.0)) * 0.5f;
        if (val == 0.0) {
            return null;
        }
        return sign + class_9285.field_49329.format(val) + (percSign ? "%" : "");
    }

    public String toString() {
        return "[Buy:" + this.buyPrice + ";Sell:" + this.sellPrice + ";UpgradeDifficulty:" + this.upgradeDifficulty + ";DefaultElement:" + String.valueOf((Object)this.element) + "];{stats:[" + MapUtils.toString(this.itemStats, class_6880::method_55840, Object::toString) + "]}";
    }

    public static class Builder {
        private final Map<class_6880<class_1320>, Double> itemStats = new HashMap<class_6880<class_1320>, Double>();
        private final Map<class_6880<class_1320>, Double> monsterGiftIncrease = new HashMap<class_6880<class_1320>, Double>();
        public final int buyPrice;
        public final int sellPrice;
        public final int upgradeDifficulty;
        private ItemElement element = ItemElement.NONE;
        private class_6880<Spell> tier1Spell;
        private class_6880<Spell> tier2Spell;
        private class_6880<Spell> tier3Spell;
        private class_6880<ArmorEffect> armorEffect;

        public Builder(int buy, int sell, int upgrade) {
            this.buyPrice = buy;
            this.sellPrice = sell;
            this.upgradeDifficulty = upgrade;
        }

        public Builder setElement(ItemElement element) {
            this.element = element;
            return this;
        }

        public Builder addAttribute(class_6880<class_1320> att, double value) {
            this.itemStats.put(att, value);
            return this;
        }

        public Builder addMonsterStat(class_6880<class_1320> att, double value) {
            this.monsterGiftIncrease.put(att, value);
            return this;
        }

        public Builder setSpell(class_6880<Spell> tier1, class_6880<Spell> tier2, class_6880<Spell> tier3) {
            this.tier1Spell = tier1;
            this.tier2Spell = tier2;
            this.tier3Spell = tier3;
            return this;
        }

        public Builder withArmorEffect(class_6880<ArmorEffect> effect) {
            this.armorEffect = effect;
            return this;
        }

        public ItemStat build() {
            return new ItemStat(this.buyPrice, this.sellPrice, this.upgradeDifficulty, this.element, Optional.ofNullable(this.tier1Spell), Optional.ofNullable(this.tier2Spell), Optional.ofNullable(this.tier3Spell), Optional.ofNullable(this.armorEffect), this.itemStats, this.monsterGiftIncrease);
        }
    }
}

