/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.datapack.ExperienceCache;
import io.github.flemmli97.runecraftory.api.datapack.ExpressionHolder;

public class SkillProperties {
    public static final SkillProperties DEFAULT = new SkillProperties(1, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new ExpressionHolder("0"));
    public static final Codec<SkillProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("max_level").forGetter(d -> d.maxLevel), (App)Codec.FLOAT.fieldOf("health_increase").forGetter(d -> Float.valueOf(d.healthIncrease)), (App)Codec.FLOAT.fieldOf("rp_increase").forGetter(d -> Float.valueOf(d.rpIncrease)), (App)Codec.FLOAT.fieldOf("str_increase").forGetter(d -> Float.valueOf(d.strIncrease)), (App)Codec.FLOAT.fieldOf("vit_increase").forGetter(d -> Float.valueOf(d.vitIncrease)), (App)Codec.FLOAT.fieldOf("intel_increase").forGetter(d -> Float.valueOf(d.intelIncrease)), (App)Codec.FLOAT.fieldOf("xp_multiplier").forGetter(d -> Float.valueOf(d.xpMultiplier)), (App)ExpressionHolder.CODEC.fieldOf("experience_per_level").forGetter(d -> d.expressionHolder)).apply((Applicative)instance, SkillProperties::new));
    private final int maxLevel;
    private final float healthIncrease;
    private final float rpIncrease;
    private final float strIncrease;
    private final float vitIncrease;
    private final float intelIncrease;
    private final float xpMultiplier;
    private final ExpressionHolder expressionHolder;
    private final ExperienceCache cache;

    public SkillProperties(int maxLevel, float healthIncrease, float rpIncrease, float strIncrease, float vitIncrease, float intelIncrease, float xpMultiplier, String expression) {
        this(maxLevel, healthIncrease, rpIncrease, strIncrease, vitIncrease, intelIncrease, xpMultiplier, new ExpressionHolder(expression));
    }

    public SkillProperties(int maxLevel, float healthIncrease, float rpIncrease, float strIncrease, float vitIncrease, float intelIncrease, float xpMultiplier, ExpressionHolder expressionHolder) {
        this.maxLevel = maxLevel;
        this.healthIncrease = healthIncrease;
        this.rpIncrease = rpIncrease;
        this.strIncrease = strIncrease;
        this.vitIncrease = vitIncrease;
        this.intelIncrease = intelIncrease;
        this.xpMultiplier = xpMultiplier;
        this.expressionHolder = expressionHolder;
        this.cache = new ExperienceCache(this::maxLevel, this.expressionHolder);
    }

    public int maxLevel() {
        return this.maxLevel;
    }

    public float healthIncrease() {
        return this.healthIncrease;
    }

    public float rpIncrease() {
        return this.rpIncrease;
    }

    public float strIncrease() {
        return this.strIncrease;
    }

    public float vitIncrease() {
        return this.vitIncrease;
    }

    public float intelIncrease() {
        return this.intelIncrease;
    }

    public float xpMultiplier() {
        return this.xpMultiplier;
    }

    public int xpAmountForNext(int level) {
        return this.cache.xpAmountForNext(level);
    }

    public long totalXpAmount(int level) {
        return this.cache.totalXpAmount(level);
    }
}

