/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_5699;

public record SpellProperties(int cooldown, int rpCost, float percentageCost, float baseDamageMultiplier, Map<Skills, Float> skillXP, Set<Skills> skills) {
    public static final Codec<SpellProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("cooldown").forGetter(SpellProperties::cooldown), (App)Codec.INT.fieldOf("runepoints_cost").forGetter(SpellProperties::rpCost), (App)Codec.FLOAT.fieldOf("percentage_cost").forGetter(SpellProperties::percentageCost), (App)Codec.FLOAT.fieldOf("base_damage_multiplier").forGetter(SpellProperties::baseDamageMultiplier), (App)Codec.unboundedMap((Codec)CodecUtils.stringEnumCodec(Skills.class, null), (Codec)Codec.FLOAT).fieldOf("skill_xp").forGetter(SpellProperties::skillXP), (App)CodecUtils.stringEnumCodec(Skills.class, null).listOf().optionalFieldOf("skills").forGetter(d -> d.skills().isEmpty() ? Optional.empty() : Optional.of(List.copyOf(d.skills())))).apply((Applicative)instance, (cooldown, rpCost, percentage, baseDamageMultiplier, skillXp, skills) -> new SpellProperties((int)cooldown, (int)rpCost, percentage.floatValue(), baseDamageMultiplier.floatValue(), (Map<Skills, Float>)skillXp, skills.orElse(List.of()))));
    public static final SpellProperties DEFAULT_PROP = new SpellProperties(20, 0, 0.0f, 1.0f, (Map<Skills, Float>)new EnumMap<Skills, Float>(Skills.class), Set.of());

    public SpellProperties(int cooldown, int rpCost, float percentageCost, float baseDamageMultiplier, Map<Skills, Float> skillXP, Collection<Skills> skills) {
        this(cooldown, rpCost, percentageCost, baseDamageMultiplier, skillXP, Set.copyOf(skills));
    }

    public SpellProperties(int cooldown, int rpCost, float percentageCost, float baseDamageMultiplier, Map<Skills, Float> skillXP, Set<Skills> skills) {
        this.cooldown = cooldown;
        this.rpCost = rpCost;
        this.percentageCost = percentageCost;
        this.baseDamageMultiplier = baseDamageMultiplier;
        this.skillXP = skillXP.isEmpty() ? ImmutableMap.of() : ImmutableMap.copyOf(new EnumMap<Skills, Float>(skillXP));
        this.skills = ImmutableSet.copyOf(skills.isEmpty() ? EnumSet.noneOf(Skills.class) : EnumSet.copyOf(skills));
    }

    public static class Builder {
        private final Map<Skills, Float> xp = new EnumMap<Skills, Float>(Skills.class);
        private final int cooldown;
        private final int rpCost;
        private final List<Skills> skills = new ArrayList<Skills>();
        private float percentage;
        private float damageMultiplier = 1.0f;

        public Builder(int cooldown, int rpCost) {
            this.cooldown = cooldown;
            this.rpCost = rpCost;
        }

        public Builder withXPGain(Skills skill, float gain) {
            this.xp.put(skill, Float.valueOf(gain));
            return this;
        }

        public Builder percentageCost(float cost) {
            this.percentage = cost;
            return this;
        }

        public Builder affectedSkill(Skills skill) {
            this.skills.add(skill);
            return this;
        }

        public Builder damageMultiplier(float multiplier) {
            this.damageMultiplier = multiplier;
            return this;
        }

        public SpellProperties build() {
            return new SpellProperties(this.cooldown, this.rpCost, this.percentage, this.damageMultiplier, this.xp, this.skills);
        }
    }
}

