/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.npc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5658;
import net.minecraft.class_5659;
import org.jetbrains.annotations.Nullable;

public record ConversationSet(String fallbackKey, @Nullable class_2960 missing, Map<String, Conversation> conversations) {
    public static final Codec<ConversationSet> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.optionalFieldOf("fallback_key").forGetter(d -> Optional.of(d.fallbackKey())), (App)Codec.unboundedMap((Codec)Codec.STRING, Conversation.CODEC).fieldOf("conversations").forGetter(d -> d.conversations)).apply((Applicative)inst, (fallback, convs) -> new ConversationSet(fallback.orElse(""), (Map<String, Conversation>)convs)));

    public ConversationSet(String fallbackKey, Map<String, Conversation> conversations) {
        this(fallbackKey, null, conversations);
    }

    public record Conversation(String translationKey, @Nullable class_5658 minHearts, @Nullable class_5658 maxHearts, boolean startingConversation, List<ConversationActionHolder> actions, class_5341[] conditions) {
        public static final Codec<Conversation> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("starting_conversation").forGetter(d -> d.startingConversation ? Optional.empty() : Optional.of(false)), (App)ConversationActionHolder.CODEC.listOf().optionalFieldOf("actions").forGetter(d -> d.actions.isEmpty() ? Optional.empty() : Optional.of(d.actions)), (App)class_5341.field_51809.listOf().fieldOf("conditions").forGetter(d -> Arrays.stream(d.conditions).toList()), (App)Codec.STRING.fieldOf("translation_key").forGetter(d -> d.translationKey), (App)class_5659.field_45888.optionalFieldOf("min_hearts").forGetter(d -> Optional.ofNullable(d.minHearts)), (App)class_5659.field_45888.optionalFieldOf("max_hearts").forGetter(d -> Optional.ofNullable(d.maxHearts))).apply((Applicative)inst, (start, action, cond, key, min, max) -> new Conversation((String)key, min.orElse(null), max.orElse(null), start.orElse(true), action.orElse(List.of()), cond.toArray(new class_5341[0]))));

        public boolean test(int hearts, class_47 ctx) {
            if (this.minHearts != null && this.minHearts.method_366(ctx) > hearts) {
                return false;
            }
            if (this.maxHearts != null && this.maxHearts.method_366(ctx) < hearts) {
                return false;
            }
            for (class_5341 condition : this.conditions) {
                if (condition.test((Object)ctx)) continue;
                return false;
            }
            return true;
        }

        public static class Builder {
            private final String translationKey;
            private class_5658 minHearts;
            private class_5658 maxHearts;
            private boolean startingConversation = true;
            private final List<ConversationActionHolder> action = new ArrayList<ConversationActionHolder>();
            private final Map<String, String> actionTranslation = new LinkedHashMap<String, String>();
            private final List<class_5341> conditions = new ArrayList<class_5341>();

            public Builder(String translationKey) {
                this.translationKey = translationKey;
            }

            public Builder min(@Nullable class_5658 minHearts) {
                this.minHearts = minHearts;
                return this;
            }

            public Builder max(@Nullable class_5658 maxHearts) {
                this.maxHearts = maxHearts;
                return this;
            }

            public Builder setAnswer() {
                this.startingConversation = false;
                return this;
            }

            public Builder addAction(ConversationActionHolder action, String enTranslation) {
                this.action.add(action);
                this.actionTranslation.put(action.translationKey, enTranslation);
                return this;
            }

            public Builder addCondition(class_5341 condition) {
                this.conditions.add(condition);
                return this;
            }

            public Conversation build() {
                return new Conversation(this.translationKey, this.minHearts, this.maxHearts, this.startingConversation, this.action, this.conditions.toArray(new class_5341[0]));
            }
        }
    }

    public record ConversationActionHolder(String translationKey, ConversationAction action, String actionValue, int friendXP) {
        public static final Codec<ConversationActionHolder> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("translation_key").forGetter(d -> d.translationKey), (App)CodecUtils.stringEnumCodec(ConversationAction.class, null).fieldOf("actions").forGetter(d -> d.action), (App)Codec.STRING.fieldOf("value").forGetter(d -> d.actionValue), (App)Codec.INT.optionalFieldOf("friend_xp").forGetter(d -> d.friendXP != 0 ? Optional.of(d.friendXP) : Optional.empty())).apply((Applicative)inst, (key, action, value, xp) -> new ConversationActionHolder((String)key, (ConversationAction)((Object)((Object)action)), (String)value, xp.orElse(0))));
    }

    public static enum ConversationAction {
        ANSWER,
        QUEST;

    }

    public static class Builder {
        private final String fallback;
        private final Map<String, Conversation> greetings = new LinkedHashMap<String, Conversation>();
        private final Map<String, String> translations = new LinkedHashMap<String, String>();

        public Builder() {
            this.fallback = "";
        }

        public Builder(String fallback, String enTranslation) {
            this.fallback = fallback;
            this.translations.put(this.fallback, enTranslation);
        }

        public Builder addConversation(Conversation.Builder conversation, String enTranslation) {
            return this.addConversation(conversation.translationKey, conversation, enTranslation);
        }

        public Builder addConversation(String key, Conversation.Builder conversation, String enTranslation) {
            this.greetings.put(key, conversation.build());
            if (this.translations.containsKey(conversation.translationKey)) {
                throw new IllegalStateException("Duplicate translation key " + conversation.translationKey);
            }
            this.translations.put(conversation.translationKey, enTranslation);
            this.translations.putAll(conversation.actionTranslation);
            return this;
        }

        public Map<String, String> getTranslations() {
            return this.translations;
        }

        public ConversationSet build() {
            return new ConversationSet(this.fallback, this.greetings);
        }
    }
}

