/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.registry;

import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCProfessions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryPoiTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class NPCProfession {
    public final boolean hasShop;
    public final boolean hasSchedule;
    public final boolean hasWorkSchedule;
    @Nullable
    private final class_5321<class_4158> poiType;
    @Nullable
    private final Predicate<class_6880<class_4158>> predicate;
    private String translationKey;
    private String ownerTranslationKey;

    public NPCProfession(Builder builder) {
        this.hasShop = builder.hasShop;
        this.hasSchedule = builder.hasSchedule;
        this.hasWorkSchedule = builder.hasWorkSchedule;
        this.poiType = builder.poiType;
        this.ownerTranslationKey = builder.ownerTranslationKey;
        this.predicate = this.poiType != null ? (!builder.allowCashPOI || RuneCraftoryPoiTypes.CASH_REGISTER.asHolder().method_40225(this.poiType) ? t -> t.method_40225(this.poiType) : t -> t.method_40225(this.poiType) || t.method_40225(RuneCraftoryPoiTypes.CASH_REGISTER.getKey())) : null;
    }

    public boolean hasShop(NPCEntity npc, class_1657 player) {
        return this.hasShop;
    }

    public boolean hasPoi() {
        return this.predicate != null;
    }

    public boolean matches(class_6880<class_4158> poi) {
        return this.predicate != null && this.predicate.test(poi);
    }

    public Set<class_2680> matchingStates(class_7225.class_7874 provider) {
        Optional type = provider.method_46762(class_7924.field_41212).method_46746(this.poiType);
        HashSet<class_2680> set = new HashSet<class_2680>();
        type.ifPresent(ref -> set.addAll(((class_4158)ref.comp_349()).comp_815()));
        if (this.matches((class_6880<class_4158>)RuneCraftoryPoiTypes.CASH_REGISTER.asHolder())) {
            set.addAll(((class_4158)RuneCraftoryPoiTypes.CASH_REGISTER.get()).comp_815());
        }
        return set;
    }

    public void handleAction(NPCEntity npc, class_1657 player, String action) {
    }

    public Map<String, List<class_2561>> actions(NPCEntity entity, class_3222 player) {
        return Map.of();
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = class_156.method_646((String)"npc.profession", (class_2960)RuneCraftoryNPCProfessions.PROFESSIONS.registry().method_10221((Object)this));
        }
        return this.translationKey;
    }

    public String getOwnerTranslationKey() {
        if (this.ownerTranslationKey == null) {
            this.ownerTranslationKey = this.getTranslationKey();
        }
        return this.ownerTranslationKey;
    }

    public static class Builder {
        private final class_5321<class_4158> poiType;
        private boolean allowCashPOI = true;
        private boolean hasShop = true;
        private boolean hasSchedule = true;
        private boolean hasWorkSchedule = true;
        private String ownerTranslationKey;

        public Builder(class_5321<class_4158> poiType) {
            this.poiType = poiType;
        }

        public Builder ignoreCashRegisterPOI() {
            this.allowCashPOI = false;
            return this;
        }

        public Builder noShop() {
            this.hasShop = false;
            return this;
        }

        public Builder noSchedule() {
            this.hasSchedule = false;
            this.hasWorkSchedule = false;
            return this;
        }

        public Builder ownerTranslationKey(String ownerTranslationKey) {
            this.ownerTranslationKey = ownerTranslationKey;
            return this;
        }

        public Builder noWorkSchedule() {
            this.hasWorkSchedule = false;
            return this;
        }
    }
}

