/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import io.github.flemmli97.runecraftory.client.gui.CompanionGui;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.network.C2SSetMonsterBehaviour;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.function.BiFunction;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_6880;
import net.minecraft.class_8710;

public class MonsterCompanionGui
extends CompanionGui<BaseMonster> {
    private BaseMonster.Behaviour updatedBehaviour;
    private final boolean fullParty;
    private final boolean hasHome;

    public MonsterCompanionGui(BaseMonster entity, boolean fullParty, boolean hasHome) {
        super(entity);
        this.fullParty = fullParty;
        this.updatedBehaviour = ((BaseMonster)this.entity).behaviourState();
        this.hasHome = hasHome;
    }

    @Override
    protected void buttons() {
        int x = 2;
        int xSize = 90;
        int y = 120;
        int buttonIndex = 0;
        ArrayList<C2SSetMonsterBehaviour.Action> buttonActions = new ArrayList<C2SSetMonsterBehaviour.Action>();
        switch (this.updatedBehaviour) {
            case WANDER_HOME: {
                if (!this.fullParty) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW);
                }
                buttonActions.add(C2SSetMonsterBehaviour.Action.FARM);
                break;
            }
            case FOLLOW: {
                buttonActions.add(C2SSetMonsterBehaviour.Action.RIDE);
                if (this.hasHome) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.HOME);
                }
                buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW_DISTANCE);
                buttonActions.add(C2SSetMonsterBehaviour.Action.STAY);
                buttonActions.add(C2SSetMonsterBehaviour.Action.WANDER);
                buttonActions.add(C2SSetMonsterBehaviour.Action.FARM);
                break;
            }
            case FOLLOW_DISTANCE: {
                buttonActions.add(C2SSetMonsterBehaviour.Action.RIDE);
                if (this.hasHome) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.HOME);
                }
                buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW);
                buttonActions.add(C2SSetMonsterBehaviour.Action.STAY);
                buttonActions.add(C2SSetMonsterBehaviour.Action.WANDER);
                buttonActions.add(C2SSetMonsterBehaviour.Action.FARM);
                break;
            }
            case STAY: {
                buttonActions.add(C2SSetMonsterBehaviour.Action.RIDE);
                if (this.hasHome) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.HOME);
                }
                buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW_DISTANCE);
                buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW);
                buttonActions.add(C2SSetMonsterBehaviour.Action.WANDER);
                buttonActions.add(C2SSetMonsterBehaviour.Action.FARM);
                break;
            }
            case WANDER: {
                if (this.hasHome) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.HOME);
                }
                if (!this.fullParty) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW);
                }
                buttonActions.add(C2SSetMonsterBehaviour.Action.FARM);
                break;
            }
            case FARM: {
                if (this.hasHome) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.HOME);
                }
                if (!this.fullParty) {
                    buttonActions.add(C2SSetMonsterBehaviour.Action.FOLLOW);
                }
                buttonActions.add(C2SSetMonsterBehaviour.Action.WANDER);
            }
        }
        ArrayList<BiFunction<Integer, Integer, class_4185>> buttons = new ArrayList<BiFunction<Integer, Integer, class_4185>>();
        for (C2SSetMonsterBehaviour.Action action : buttonActions) {
            buttons.add((xOff, yOff) -> class_4185.method_46430((class_2561)class_2561.method_43471((String)type.translation), b -> this.handlePress(type)).method_46434(this.leftPos + x + xOff, this.topPos + y + yOff, xSize, 20).method_46431());
        }
        if (this.field_22787.field_1724.method_6047().method_7909() == RuneCraftoryItems.MOB_STAFF.get()) {
            if (this.updatedBehaviour == BaseMonster.Behaviour.WANDER) {
                buttons.add((xOff, yOff) -> class_4185.method_46430((class_2561)class_2561.method_43471((String)C2SSetMonsterBehaviour.Action.CENTER.translation), b -> this.handlePress(C2SSetMonsterBehaviour.Action.CENTER)).method_46434(this.leftPos + x + xOff, this.topPos + y + yOff, xSize, 20).method_46431());
            }
            if (this.updatedBehaviour == BaseMonster.Behaviour.FARM) {
                buttons.add((xOff, yOff) -> class_4185.method_46430((class_2561)class_2561.method_43471((String)C2SSetMonsterBehaviour.Action.CENTER_FARM.translation), b -> this.handlePress(C2SSetMonsterBehaviour.Action.CENTER_FARM)).method_46434(this.leftPos + x + xOff, this.topPos + y + yOff, xSize, 20).method_46431());
                buttons.add((xOff, yOff) -> class_4185.method_46430((class_2561)class_2561.method_43471((String)C2SSetMonsterBehaviour.Action.HARVESTINV.translation), b -> this.handlePress(C2SSetMonsterBehaviour.Action.HARVESTINV)).method_46434(this.leftPos + x + xOff, this.topPos + y + yOff, xSize, 20).method_46431());
                buttons.add((xOff, yOff) -> class_4185.method_46430((class_2561)class_2561.method_43471((String)C2SSetMonsterBehaviour.Action.SEEDINV.translation), b -> this.handlePress(C2SSetMonsterBehaviour.Action.SEEDINV)).method_46434(this.leftPos + x + xOff, this.topPos + y + yOff, xSize, 20).method_46431());
            }
        }
        for (BiFunction biFunction : buttons) {
            if (buttonIndex + 1 == buttons.size() && buttons.size() % 2 == 1) {
                this.method_37063((class_364)((class_4185)biFunction.apply((int)((double)(xSize + 5) * 0.5), buttonIndex / 2 * 23)));
            } else {
                this.method_37063((class_364)((class_4185)biFunction.apply(buttonIndex % 2 == 0 ? 0 : xSize + 6, buttonIndex / 2 * 23)));
            }
            ++buttonIndex;
        }
    }

    private void handlePress(C2SSetMonsterBehaviour.Action action) {
        LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SSetMonsterBehaviour(((BaseMonster)this.entity).method_5628(), action));
        this.updatedBehaviour = action.behaviour;
        this.field_22787.method_1507(null);
        this.field_22787.field_1687.method_60511((class_1657)this.field_22787.field_1724, this.field_22787.field_1724.method_23317(), this.field_22787.field_1724.method_23318(), this.field_22787.field_1724.method_23321(), (class_6880)class_3417.field_14622, class_3419.field_15248, 1.0f, 1.2f);
    }
}

