/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.client.gui.widgets.SpriteResources;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopState;
import io.github.flemmli97.runecraftory.common.network.C2SNPCInteraction;
import io.github.flemmli97.runecraftory.common.network.C2SProcreationRequest;
import io.github.flemmli97.runecraftory.common.world.data.family.SyncedFamilyData;
import io.github.flemmli97.runecraftory.mixinhelper.GuiGraphicsExtension;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7225;
import net.minecraft.class_8710;

public class NPCGui<T extends NPCEntity>
extends class_437 {
    private static final class_2960 TEXTURE = RuneCraftory.modRes("hud/generic_view");
    private final int offSetX = 140;
    private final int offSetY = 50;
    protected int leftPos;
    protected int topPos;
    private int lines;
    protected final T entity;
    private final ShopState isShopOpen;
    private final boolean canFollow;
    private List<class_5481> components;
    private final Map<String, List<class_2561>> actions;
    private final class_2960 quest;
    private final SyncedFamilyData family;
    private final List<ToolTipRenderer> tooltipComponents = new ArrayList<ToolTipRenderer>();

    public NPCGui(T entity, ShopState isShopOpen, boolean canFollow, SyncedFamilyData family, Map<String, List<class_2561>> actions, class_2960 quest) {
        super(entity.method_5476());
        this.entity = entity;
        this.isShopOpen = isShopOpen;
        this.canFollow = canFollow;
        this.actions = actions;
        this.quest = quest;
        this.family = family;
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = this.field_22789 - this.offSetX;
        this.topPos = this.offSetY;
        this.buttons();
    }

    protected void method_57734(float partialTick) {
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25420(graphics, mouseX, mouseY, partialTick);
        int posX = 25;
        int posY = 25;
        int texY = this.lines * 13 + 10;
        boolean renderParents = this.family.father().isPresent() || this.family.mother().isPresent();
        graphics.method_52706(TEXTURE, posX, posY, 150, texY);
        int txtOffX = posX + 5;
        int txtOffY = posY + 5;
        GuiGraphicsExtension.drawCenteredString(graphics, this.field_22793, this.entity.method_5477(), (float)(posX + 75), (float)txtOffY, 0, false);
        int y = 1;
        graphics.method_52706(SpriteResources.HEART_ICON, posX + 65, txtOffY + 13 * y, 8, 8);
        graphics.method_51433(this.field_22793, "" + this.entity.friendPoints((class_1657)this.field_22787.field_1724), posX + 65 + 10, txtOffY + 13 * y, 0, false);
        ++y;
        if (renderParents) {
            if (this.family.father().isEmpty()) {
                graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"runecraftory.gui.npc.parent"), txtOffX, txtOffY + 13 * y, 0, false);
                ++y;
                for (class_5481 ch : this.field_22793.method_1728((class_5348)this.family.mother().get(), 140)) {
                    graphics.method_51430(this.field_22793, ch, txtOffX, txtOffY + 13 * y, 0, false);
                    ++y;
                }
            } else if (this.family.mother().isEmpty()) {
                graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"runecraftory.gui.npc.parent"), txtOffX, txtOffY + 13 * y, 0);
                ++y;
                for (class_5481 ch : this.field_22793.method_1728((class_5348)this.family.father().get(), 140)) {
                    graphics.method_51430(this.field_22793, ch, txtOffX, txtOffY + 13 * y, 0, false);
                    ++y;
                }
            } else {
                graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"runecraftory.gui.npc.parents"), txtOffX, txtOffY + 13 * y, 0);
                ++y;
                for (class_5481 ch : this.field_22793.method_1728((class_5348)this.family.father().get(), 140)) {
                    graphics.method_51430(this.field_22793, ch, txtOffX, txtOffY + 13 * y, 0, false);
                    ++y;
                }
                for (class_5481 ch : this.field_22793.method_1728((class_5348)this.family.mother().get(), 140)) {
                    graphics.method_51430(this.field_22793, ch, txtOffX, txtOffY + 13 * y, 0, false);
                    ++y;
                }
            }
        }
        if (!this.entity.method_6109()) {
            switch (this.family.relationship()) {
                case NONE: {
                    break;
                }
                case DATING: {
                    RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
                    graphics.method_52706(SpriteResources.HEARTH_LETTER_ICON, txtOffX, txtOffY + 13 * y, 10, 8);
                    graphics.method_51439(this.field_22793, this.family.partner().get(), txtOffX + 12, txtOffY + 13 * y, 0, false);
                    ++y;
                    break;
                }
                case MARRIED: {
                    RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
                    graphics.method_52706(SpriteResources.ENGAGEMENT_RING_ICON, txtOffX, txtOffY + 13 * y, 10, 8);
                    graphics.method_51439(this.field_22793, this.family.partner().get(), txtOffX + 12, txtOffY + 13 * y, 0, false);
                    ++y;
                }
            }
            ++y;
        }
        int shopY = txtOffY + 13 * y;
        int shopSizeY = -5;
        if (!this.entity.method_6109()) {
            class_5250 shopComp = null;
            if (((NPCEntity)this.entity).getProfession().hasWorkSchedule) {
                shopComp = class_2561.method_43471((String)((NPCEntity)this.entity).getProfession().getOwnerTranslationKey());
            }
            if (shopComp != null) {
                if (this.isShopOpen == ShopState.NOBED || this.isShopOpen == ShopState.NOWORKPLACE) {
                    shopComp.method_27692(class_124.field_1079);
                }
                for (class_2561 comp : this.field_22793.method_1728((class_5348)shopComp, 140)) {
                    float xCenter = (float)(posX + 75) - (float)this.field_22787.field_1772.method_30880((class_5481)comp) * 0.5f;
                    graphics.method_51430(this.field_22793, (class_5481)comp, (int)xCenter, txtOffY + 13 * y, 0, false);
                    ++y;
                    shopSizeY += 13;
                }
            }
            if (((NPCEntity)this.entity).getProfession().hasWorkSchedule) {
                for (class_2561 comp : ((NPCEntity)this.entity).getNPCSchedule().viewSchedule()) {
                    for (class_5481 formatted : this.field_22793.method_1728((class_5348)comp, 140)) {
                        graphics.method_51430(this.field_22793, formatted, txtOffX, txtOffY + 13 * y, 0, false);
                        ++y;
                    }
                }
            }
        }
        if (this.components != null && this.isHovering(txtOffX, shopY, 145, shopSizeY, mouseX, mouseY)) {
            graphics.method_51447(this.field_22793, this.components, mouseX, mouseY);
        }
        this.tooltipComponents.forEach(r -> r.render(graphics, mouseX, mouseY));
        this.lines = y;
    }

    protected void buttons() {
        int x = -52;
        int xSize = 150;
        int y = 0;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)C2SNPCInteraction.Action.TALK.translation), b -> {
            LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SNPCInteraction(this.entity.method_5628(), C2SNPCInteraction.Action.TALK));
            this.field_22787.method_1507(null);
        }).method_46434(this.leftPos + x, this.topPos + y, xSize, 20).method_46431());
        if (this.canFollow) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)C2SNPCInteraction.Action.FOLLOW.translation), b -> {
                LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SNPCInteraction(this.entity.method_5628(), C2SNPCInteraction.Action.FOLLOW));
                this.field_22787.method_1507(null);
            }).method_46434(this.leftPos + x, this.topPos + (y += 30), xSize, 20).method_46431());
        }
        if (!this.entity.method_6109() && this.isShopOpen == ShopState.OPEN) {
            if (((NPCEntity)this.entity).getProfession().hasShop) {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)C2SNPCInteraction.Action.SHOP.translation), b -> {
                    LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SNPCInteraction(this.entity.method_5628(), C2SNPCInteraction.Action.SHOP));
                    this.field_22787.method_1507(null);
                }).method_46434(this.leftPos + x, this.topPos + (y += 30), xSize, 20).method_46431());
            }
            for (Map.Entry<String, List<class_2561>> action : this.actions.entrySet()) {
                this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)action.getKey()), b -> {
                    LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SNPCInteraction(this.entity.method_5628(), (String)action.getKey()));
                    this.field_22787.method_1507(null);
                }).method_46434(this.leftPos + x, this.topPos + (y += 30), xSize, 20).method_46431());
                int tooltipX = this.leftPos + x;
                int tooltipY = this.topPos + y;
                this.tooltipComponents.add((graphics, mouseX, mouseY) -> {
                    if (this.isHovering(tooltipX, tooltipY, xSize, 20, mouseX, mouseY)) {
                        graphics.method_51437(this.field_22793, (List)action.getValue(), Optional.empty(), mouseX, mouseY);
                    }
                });
            }
        }
        if (this.quest != null) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)C2SNPCInteraction.Action.QUEST.translation), b -> {
                LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SNPCInteraction(this.entity.method_5628(), C2SNPCInteraction.Action.QUEST, this.quest.toString()));
                this.field_22787.method_1507(null);
            }).method_46434(this.leftPos + x, this.topPos + (y += 30), xSize, 20).method_46431());
        }
        if (!this.entity.method_6109() && this.family.canProcreate()) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"runecraftory.gui.npc.procreate"), b -> {
                LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SProcreationRequest(this.entity.method_5628()));
                this.field_22787.method_1507(null);
            }).method_46434(this.leftPos + x, this.topPos + (y += 30), xSize, 20).method_46431());
        }
        if (this.isShopOpen == ShopState.NOBED) {
            this.components = new ArrayList<class_5481>();
            this.components.addAll(this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"runecraftory.gui.npc.bed.no"), 150));
        }
        if (!this.entity.method_6109() && this.isShopOpen == ShopState.NOWORKPLACE && ((NPCEntity)this.entity).getProfession().hasPoi()) {
            this.components = new ArrayList<class_5481>();
            this.components.addAll(this.field_22793.method_1728((class_5348)class_2561.method_43469((String)"runecraftory.gui.npc.workplace.no", (Object[])new Object[]{this.formatShopPoi(((NPCEntity)this.entity).getProfession())}), 150));
        }
    }

    private class_2561 formatShopPoi(NPCProfession profession) {
        Set<class_2680> set = profession.matchingStates((class_7225.class_7874)this.field_22787.field_1687.method_30349());
        class_5250 comp = class_2561.method_43470((String)"");
        set.stream().map(class_4970.class_4971::method_26204).distinct().map(class_2248::method_9518).forEach(c -> {
            if (comp.method_10855().isEmpty()) {
                comp.method_10852((class_2561)c);
            } else {
                comp.method_10852((class_2561)class_2561.method_43470((String)", ").method_10852((class_2561)c));
            }
        });
        return comp.method_27692(class_124.field_1075);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return true;
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public void method_25432() {
        super.method_25432();
        LoaderNetwork.INSTANCE.sendToServer((class_8710)new C2SNPCInteraction(this.entity.method_5628(), C2SNPCInteraction.Action.CLOSE));
    }

    static interface ToolTipRenderer {
        public void render(class_332 var1, int var2, int var3);
    }
}

