/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model;

import io.github.flemmli97.runecraftory.client.TransformationHelper;
import io.github.flemmli97.runecraftory.client.model.HumanoidModelLocations;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveStateHolder;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import io.github.flemmli97.runecraftory.mixinhelper.HumanoidMainHand;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.DeformationChange;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ItemHolderModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.model.PoseExtended;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3882;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HumanoidBasedModel<T extends class_1309 & MoveStateHolder>
extends class_583<T>
implements ItemHolderModel,
class_3882,
ExtendedModel {
    protected final ReloadableCache<ModelPartsContainer> model;
    protected final ReloadableCache<BedrockAnimations> attackAnimations;
    protected final ReloadableCache<BedrockAnimations> miscAnimations;
    public ModelPartsContainer.ModelPartExtended head;
    public ModelPartsContainer.ModelPartExtended body;
    public ModelPartsContainer.ModelPartExtended rightArm;
    public ModelPartsContainer.ModelPartExtended rightItem;
    public ModelPartsContainer.ModelPartExtended leftArm;
    public ModelPartsContainer.ModelPartExtended leftItem;
    @Nullable
    public ModelPartsContainer.ModelPartExtended legBase;
    public ModelPartsContainer.ModelPartExtended rightLeg;
    public ModelPartsContainer.ModelPartExtended leftLeg;
    @Nullable
    public ModelPartsContainer.ModelPartExtended vehicleAttachment;
    protected Vector3f bodyVehicleOffset = new Vector3f(0.0f, -12.0f, 0.0f);
    protected final class_630 dummyHead = new class_630(new ArrayList(), new HashMap());
    public class_572.class_573 leftArmPose = class_572.class_573.field_3409;
    public class_572.class_573 rightArmPose = class_572.class_573.field_3409;
    public boolean crouching;
    private float partialTicks;
    protected class_572<T> delegate;

    public HumanoidBasedModel() {
        this(HumanoidModelLocations.DEFAULT_PLAYER_LOCATION, HumanoidModelLocations.DEFAULT_NPC_ANIMATION, 0.0f);
    }

    public HumanoidBasedModel(class_2960 modelLocation, class_2960 animationLocation, float inflate) {
        super(class_1921::method_23580);
        this.model = GeoModelManager.getInstance().getModel(modelLocation, inflate != 0.0f ? new DeformationChange(inflate) : DeformationChange.NONE, model -> {
            this.head = model.getPart("Head");
            this.body = model.getPart("Body");
            this.rightItem = model.getPart("RightItemRoot");
            this.leftItem = model.getPart("LeftItemRoot");
            this.rightArm = model.getPart("RightArm");
            this.leftArm = model.getPart("LeftArm");
            this.legBase = model.getOptionalPart("LegsBase").orElse(null);
            this.rightLeg = model.getPart("RightLeg");
            this.leftLeg = model.getPart("LeftLeg");
            this.vehicleAttachment = model.getOptionalPart("VehicleAttachment").orElse(null);
            if (this.vehicleAttachment != null) {
                this.vehicleAttachment.updateDefaultPose(this.vehicleAttachment.getDefaultPose().withScale(0.0f, 0.0f, 0.0f));
                PoseExtended bodyPose = this.body.getDefaultPose();
                PoseExtended attachmentPose = this.vehicleAttachment.getDefaultPose();
                this.bodyVehicleOffset = new Vector3f(attachmentPose.x - bodyPose.x, attachmentPose.y - bodyPose.y, attachmentPose.z - bodyPose.z);
            }
        });
        this.attackAnimations = GeoAnimationManager.getInstance().getAnimation(HumanoidModelLocations.DEFAULT_PLAYER_LOCATION);
        this.miscAnimations = GeoAnimationManager.getInstance().getOptionalAnimation(animationLocation);
    }

    public ModelPartsContainer getModel() {
        return (ModelPartsContainer)this.model.get();
    }

    public void transform(class_1306 hand, class_4587 stack) {
        if (hand == class_1306.field_6182) {
            this.leftItem.translateAndRotateWithParents(stack);
        } else {
            this.rightItem.translateAndRotateWithParents(stack);
        }
        stack.method_22904(0.0, 0.125, -0.125);
    }

    public class_630 method_2838() {
        this.dummyHead.field_3657 = this.head.x;
        this.dummyHead.field_3656 = this.head.y;
        this.dummyHead.field_3655 = this.head.z;
        this.dummyHead.field_3654 = this.head.xRot;
        this.dummyHead.field_3675 = this.head.yRot;
        this.dummyHead.field_3674 = this.head.zRot;
        this.dummyHead.field_37938 = this.head.xScale;
        this.dummyHead.field_37939 = this.head.yScale;
        this.dummyHead.field_37940 = this.head.zScale;
        return this.dummyHead;
    }

    public void setDelegate(class_572<T> delegate) {
        this.delegate = delegate;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.method_2816(entity, limbSwing, limbSwingAmount, partialTick);
        this.partialTicks = partialTick;
        if (this.delegate != null) {
            this.delegate.field_3447 = this.field_3447;
            this.delegate.field_3449 = this.field_3449;
            this.delegate.field_3448 = this.field_3448;
            this.delegate.field_3399 = this.leftArmPose;
            this.delegate.field_3395 = this.rightArmPose;
            this.delegate.field_3400 = this.crouching;
            this.delegate.method_17086(entity, limbSwing, limbSwingAmount, partialTick);
        }
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.preAnimSetup(entity, limbSwing, limbSwingAmount, netHeadYaw, ageInTicks, headPitch);
        PoseExtended ext = null;
        PoseExtended ext2 = null;
        if (this.field_3449) {
            ext = this.leftLeg.extendedPose();
            ext2 = this.rightLeg.extendedPose();
        }
        ((BedrockAnimations)this.attackAnimations.get()).doAnimation((ExtendedModel)this, ((AnimatedEntity)entity).getAnimationHandler(), this.partialTicks, entity.method_6068() == class_1306.field_6182);
        if (this.delegate != null) {
            this.method_17081((class_583<T>)this.delegate);
        }
        if (this.field_3449) {
            this.body.x = this.body.getDefaultPose().x;
            this.body.y = this.body.getDefaultPose().y;
            this.body.z = this.body.getDefaultPose().z;
            class_4587 stack = new class_4587();
            this.body.translateAndRotate(stack);
            Vector3f v = this.bodyVehicleOffset != null ? new Vector3f((Vector3fc)this.bodyVehicleOffset) : new Vector3f();
            v.mulTranspose((Matrix3fc)stack.method_23760().method_23762());
            this.body.x += v.x() - this.bodyVehicleOffset.x;
            this.body.y += v.y() - this.bodyVehicleOffset.y;
            this.body.z += v.z() - this.bodyVehicleOffset.z;
            this.leftLeg.loadPose(ext);
            this.rightLeg.loadPose(ext2);
        }
    }

    protected void preAnimSetup(T entity, float limbSwing, float limbSwingAmount, float netHeadYaw, float ageInTicks, float headPitch) {
        if (this.delegate != null) {
            this.delegate.method_17087(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.copyFrom((class_583<?>)this.delegate);
        }
        BedrockAnimations animation = (BedrockAnimations)this.attackAnimations.get();
        HumanoidBasedModel.setupAnimationValues(this, animation, limbSwing, limbSwingAmount, netHeadYaw, headPitch);
        BedrockAnimations miscAnimation = (BedrockAnimations)this.miscAnimations.get();
        HumanoidBasedModel.setupAnimationValues(this, animation, limbSwing, limbSwingAmount, netHeadYaw, headPitch);
        miscAnimation.doAnimation((ExtendedModel)this, "idle", ((class_1309)entity).field_6012, this.partialTicks, 1.0f);
        miscAnimation.doAnimation((ExtendedModel)this, "walk", ((class_1309)entity).field_6012, this.partialTicks, ((MoveStateHolder)entity).interpolatedMoveTick(this.partialTicks));
        miscAnimation.doAnimation((ExtendedModel)this, "run", ((class_1309)entity).field_6012, this.partialTicks, ((MoveStateHolder)entity).interpolatedMoveTickOf(MoveType.RUN, this.partialTicks));
        miscAnimation.doAnimation((ExtendedModel)this, "swim", ((class_1309)entity).field_6012, this.partialTicks, entity.method_6024(this.partialTicks));
        if (this.crouching) {
            miscAnimation.doAnimation((ExtendedModel)this, "crouching", ((class_1309)entity).field_6012, this.partialTicks, 1.0f, false, true);
        }
        if (this.field_3449) {
            miscAnimation.doAnimation((ExtendedModel)this, "riding", ((class_1309)entity).field_6012, this.partialTicks, 1.0f);
        }
    }

    public static void setupAnimationValues(HumanoidBasedModel<?> model, BedrockAnimations animation, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch) {
        animation.setVariable("query.head_x_rotation", () -> headPitch);
        animation.setVariable("query.head_y_rotation", () -> netHeadYaw);
        animation.setVariable("left_held", () -> model.leftArmPose != class_572.class_573.field_3409 ? 1.0 : 0.0);
        animation.setVariable("left_arm_x_rot", () -> model.leftArm != null ? (double)(model.leftArm.xRot * 57.295776f) : 0.0);
        animation.setVariable("right_held", () -> model.rightArmPose != class_572.class_573.field_3409 ? 1.0 : 0.0);
        animation.setVariable("right_arm_x_rot", () -> model.rightArm != null ? (double)(model.rightArm.xRot * 57.295776f) : 0.0);
        animation.setVariable("limb_swing", () -> limbSwing * 57.295776f);
        animation.setVariable("limb_swing_amount", () -> limbSwingAmount * 57.295776f);
        animation.setVariable("crouching", () -> model.crouching ? 1.0 : 0.0);
        animation.setVariable("riding", () -> model.field_3449 ? 1.0 : 0.0);
    }

    public void method_2828(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, int color) {
        ((ModelPartsContainer)this.model.get()).getRoot().renderForced(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void copyFrom(@Nullable class_583<?> model) {
        this.getModel().resetPoses();
        if (model == null) {
            return;
        }
        model.method_17081((class_583)this);
        if (model instanceof class_572) {
            class_572 other = (class_572)model;
            class_5603 body = other.field_3391.method_32084();
            this.body.loadPose(body);
            this.leftArm.loadPose(TransformationHelper.withoutParent(body, other.field_27433.method_32084()));
            this.rightArm.loadPose(TransformationHelper.withoutParent(body, other.field_3401.method_32084()));
            this.leftLeg.loadPose(TransformationHelper.withoutParent(body, other.field_3397.method_32084()));
            this.rightLeg.loadPose(TransformationHelper.withoutParent(body, other.field_3392.method_32084()));
            this.head.loadPose(TransformationHelper.withoutParent(body, other.field_3398.method_32084()));
        }
    }

    public void method_17081(class_583<T> model) {
        HumanoidBasedModel other;
        super.method_17081(model);
        if (model instanceof HumanoidBasedModel) {
            other = (HumanoidBasedModel)model;
            other.getModel().getRoot().forEach((name, part) -> this.getModel().getOptionalPart(name).ifPresentOrElse(p -> part.loadPose(p.extendedPose()), () -> ((ModelPartsContainer.ModelPartExtended)part).reset()));
        }
        if (model instanceof class_572) {
            other = (class_572)model;
            PoseExtended body = this.body.extendedPose();
            ((class_572)other).field_3391.field_3665 = this.body.visible;
            ((class_572)other).field_3391.method_32085(body.asPartPose());
            ((class_572)other).field_3398.field_3665 = this.head.visible;
            this.apply(((class_572)other).field_3398, body, this.head);
            ((class_572)other).field_27433.field_3665 = this.leftArm.visible;
            this.apply(((class_572)other).field_27433, body, this.leftArm);
            HumanoidMainHand hands = (HumanoidMainHand)model;
            hands.runecraftory$getLeftHandItem().loadPose(this.leftItem.storePose());
            ((class_572)other).field_3401.field_3665 = this.rightArm.visible;
            this.apply(((class_572)other).field_3401, body, this.rightArm);
            hands.runecraftory$getRightHandItem().loadPose(this.rightItem.storePose());
            if (!model.field_3449) {
                this.apply(((class_572)other).field_3397, body, this.leftLeg);
                this.apply(((class_572)other).field_3392, body, this.rightLeg);
            } else {
                ((class_572)other).field_3397.method_32085(TransformationHelper.withParent(body, ((class_572)other).field_3397.method_32084()));
                ((class_572)other).field_3392.method_32085(TransformationHelper.withParent(body, ((class_572)other).field_3392.method_32084()));
            }
            ((class_572)other).field_3397.field_3665 = this.leftLeg.visible;
            ((class_572)other).field_3392.field_3665 = this.rightLeg.visible;
            ((class_572)other).field_3394.field_3665 = ((class_572)other).field_3398.field_3665;
            ((class_572)other).field_3394.method_17138(((class_572)other).field_3398);
        }
    }

    private void apply(class_630 model, PoseExtended body, ModelPartsContainer.ModelPartExtended first) {
        model.method_32085(TransformationHelper.withParent(body, first.storePose()));
    }

    public void setAllVisible(boolean visible) {
        this.getModel().getRoot().forEach((name, part) -> {
            part.visible = visible;
        });
    }

    public void copyVisibilityFrom(HumanoidBasedModel<T> model) {
        model.getModel().getRoot().forEach((name, part) -> this.getModel().getOptionalPart(name).ifPresentOrElse(p -> {
            p.visible = part.visible;
        }, () -> ((ModelPartsContainer.ModelPartExtended)part).reset()));
    }
}

