/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.monster;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.model.monster.RaccoonBaseModel;
import io.github.flemmli97.runecraftory.client.model.monster.RaccoonBerserkModel;
import io.github.flemmli97.runecraftory.client.model.monster.RaccoonModel;
import io.github.flemmli97.runecraftory.client.render.RenderMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.Raccoon;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;

public class RaccoonRender<T extends Raccoon>
extends RenderMonster<T, RaccoonBaseModel<T>> {
    private static final class_2960 BERSERK_TEXTURE = RuneCraftory.modRes("textures/entity/monsters/raccoon_berserk.png");
    private final RaccoonBaseModel<T> normalModel;
    private final RaccoonBaseModel<T> berserkModel;
    private boolean clone;

    public RaccoonRender(class_5617.class_5618 ctx) {
        super(ctx, new RaccoonModel(), RuneCraftory.modRes("textures/entity/monsters/raccoon.png"), 0.5f);
        this.normalModel = (RaccoonBaseModel)this.field_4737;
        this.berserkModel = new RaccoonBerserkModel();
    }

    @Override
    public class_2960 getTextureLocation(T entity) {
        return this.field_4737 == this.berserkModel ? BERSERK_TEXTURE : super.getTextureLocation(entity);
    }

    @Override
    public void render(T entity, float entityYaw, float partialTicks, class_4587 stack, class_4597 buffer, int packedLight) {
        this.field_4673 = ((Raccoon)entity).isBerserk() ? 0.7f : 0.5f;
        AnimationState anim = ((Raccoon)entity).getAnimationHandler().getAnimation();
        if (anim != null && (anim.is(new String[]{Raccoon.TRANSFORM}) || anim.is(new String[]{Raccoon.UNTRANSFORM}))) {
            int tick = (int)anim.getTick(1.0f);
            if (tick < 10) {
                this.field_4737 = tick % 3 == 0 ? this.berserkModel : this.normalModel;
            } else if (tick < 20) {
                this.field_4737 = tick % 4 <= 1 ? this.berserkModel : this.normalModel;
            } else if (tick < 30) {
                RaccoonBaseModel<T> raccoonBaseModel = this.field_4737 = tick % 5 <= 3 ? this.berserkModel : this.normalModel;
            }
            if (anim.is(new String[]{Raccoon.UNTRANSFORM})) {
                this.field_4737 = this.field_4737 == this.berserkModel || tick > 30 ? this.normalModel : this.berserkModel;
            }
        } else {
            RaccoonBaseModel<T> raccoonBaseModel = this.field_4737 = ((Raccoon)entity).isBerserk() ? this.berserkModel : this.normalModel;
        }
        if (!this.clone && anim != null && anim.is(new String[]{Raccoon.CLONE}) && ((Raccoon)entity).cloneCenter().isPresent()) {
            class_243 center = ((Raccoon)entity).cloneCenter().get();
            double dx = class_3532.method_16436((double)partialTicks, (double)entity.method_23317(), (double)((Raccoon)entity).field_6038) - center.method_10216();
            double dy = class_3532.method_16436((double)partialTicks, (double)entity.method_23318(), (double)((Raccoon)entity).field_5971) - center.method_10214();
            double dz = class_3532.method_16436((double)partialTicks, (double)entity.method_23321(), (double)((Raccoon)entity).field_5989) - center.method_10215();
            stack.method_22903();
            stack.method_22904(-dx, -dy, -dz);
            float tick = class_3532.method_16439((float)partialTicks, (float)((Raccoon)entity).field_6012, (float)(((Raccoon)entity).field_6012 + 1));
            this.clone = true;
            for (int i = 0; i < Raccoon.CLONE_POS.length; ++i) {
                class_243 vec3 = Raccoon.CLONE_POS[i];
                if ((tick + (float)(i * 2)) % 8.0f <= 4.0f) continue;
                stack.method_22903();
                stack.method_22904(vec3.method_10216(), vec3.method_10214(), vec3.method_10215());
                int rotAmount = i - ((Raccoon)entity).cloneIndex();
                stack.method_22907(class_7833.field_40716.rotationDegrees((float)(-rotAmount * 90)));
                class_310.method_1551().method_1561().method_3954(entity, 0.0, 0.0, 0.0, entityYaw, partialTicks, stack, buffer, packedLight);
                stack.method_22909();
            }
            this.clone = false;
            stack.method_22909();
        } else {
            super.render(entity, entityYaw, partialTicks, stack, buffer, packedLight);
        }
    }
}

