/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.npc;

import io.github.flemmli97.runecraftory.client.model.HumanoidBasedModel;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveStateHolder;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_583;

public class FeatureModel<T extends class_1309>
extends class_583<T>
implements ExtendedModel {
    protected final ReloadableCache<ModelPartsContainer> model;
    protected final ReloadableCache<BedrockAnimations> animations;
    protected HumanoidBasedModel<?> main;
    private float partialTicks;

    public FeatureModel(class_2960 location) {
        super(class_1921::method_23580);
        this.model = this.load(location);
        this.animations = null;
    }

    public FeatureModel(class_2960 location, class_2960 animation) {
        super(class_1921::method_23580);
        this.model = this.load(location);
        this.animations = GeoAnimationManager.getInstance().getAnimation(animation);
    }

    protected ReloadableCache<ModelPartsContainer> load(class_2960 location) {
        return GeoModelManager.getInstance().getModel(location);
    }

    public void setMain(HumanoidBasedModel<?> main) {
        this.main = main;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.method_2816(entity, limbSwing, limbSwingAmount, partialTick);
        this.partialTicks = partialTick;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.getModel() == null || this.main == null) {
            return;
        }
        this.getModel().resetPoses();
        if (this.animations != null) {
            BedrockAnimations animations = (BedrockAnimations)this.animations.get();
            HumanoidBasedModel.setupAnimationValues(this.main, animations, limbSwing, limbSwingAmount, netHeadYaw, headPitch);
            animations.doAnimation((ExtendedModel)this, "idle", ((class_1309)entity).field_6012, this.partialTicks, 1.0f);
            animations.doAnimation((ExtendedModel)this, "walk", ((class_1309)entity).field_6012, this.partialTicks, ((MoveStateHolder)entity).interpolatedMoveTick(this.partialTicks));
            animations.doAnimation((ExtendedModel)this, "run", ((class_1309)entity).field_6012, this.partialTicks, ((MoveStateHolder)entity).interpolatedMoveTickOf(MoveType.RUN, this.partialTicks));
            animations.doAnimation((ExtendedModel)this, "swim", ((class_1309)entity).field_6012, this.partialTicks, entity.method_6024(this.partialTicks));
            if (this.main.crouching) {
                animations.doAnimation((ExtendedModel)this, "crouching", ((class_1309)entity).field_6012, this.partialTicks, 1.0f, false, true);
            }
            if (this.field_3449) {
                animations.doAnimation((ExtendedModel)this, "riding", ((class_1309)entity).field_6012, this.partialTicks, 1.0f);
            }
        }
    }

    public void method_2828(class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, int color) {
        if (this.getModel() == null) {
            return;
        }
        ((ModelPartsContainer)this.model.get()).getRoot().render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public ModelPartsContainer getModel() {
        return (ModelPartsContainer)this.model.get();
    }
}

