/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.npc;

import io.github.flemmli97.runecraftory.client.model.HumanoidBasedModel;
import io.github.flemmli97.runecraftory.client.render.npc.FeatureModel;
import io.github.flemmli97.runecraftory.client.render.npc.NPCFeatureRenderer;
import io.github.flemmli97.runecraftory.client.render.npc.NPCRender;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ModelAttachmentsType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_922;

public class ModelFeatureRender
extends NPCFeatureRenderer<ModelAttachmentsType.ModelAttachmentsFeature> {
    private static final Map<class_2960, FeatureModel<NPCEntity>> MODELS_CACHE = new HashMap<class_2960, FeatureModel<NPCEntity>>();
    private static final Map<class_2960, class_2960> TEXTURE_CACHE = new HashMap<class_2960, class_2960>();

    private static class_2960 textureFrom(class_2960 texture) {
        return TEXTURE_CACHE.computeIfAbsent(texture, k -> class_2960.method_60655((String)texture.method_12836(), (String)("textures/" + texture.method_12832() + ".png")));
    }

    @Override
    public <E extends NPCEntity> void onSetup(ModelAttachmentsType.ModelAttachmentsFeature feature, NPCRender<E> renderer, E entity, class_4587 stack) {
        this.setupVisibility((HumanoidBasedModel)renderer.method_4038(), feature.hidden());
    }

    @Override
    public <E extends NPCEntity> void render(ModelAttachmentsType.ModelAttachmentsFeature feature, NPCRender<E> renderer, E entity, class_4587 poseStack, class_4597 buffer, int packedLight, float partialTicks, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (ModelAttachmentsType.ModelAttachment attachment : feature.attachments()) {
            this.renderModel(attachment, renderer, entity, poseStack, buffer, packedLight, partialTicks, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    private <E extends NPCEntity> void renderModel(ModelAttachmentsType.ModelAttachment attachment, NPCRender<E> renderer, E entity, class_4587 poseStack, class_4597 buffer, int packedLight, float partialTicks, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        FeatureModel model = MODELS_CACHE.computeIfAbsent(attachment.model(), k -> new FeatureModel(attachment.model(), attachment.model()));
        poseStack.method_22903();
        model.setMain((HumanoidBasedModel)renderer.method_4038());
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        model.setMain(null);
        ModelAttachmentsType.Location location = attachment.location();
        this.translateToPart((HumanoidBasedModel)renderer.method_4038(), location, poseStack);
        poseStack.method_22904(0.0, -1.5, 0.0);
        model.method_2828(poseStack, buffer.getBuffer(model.method_23500(ModelFeatureRender.textureFrom(attachment.texture()))), packedLight, class_922.method_23622(entity, (float)0.0f), -1);
        poseStack.method_22909();
    }

    private <E extends NPCEntity> void setupVisibility(HumanoidBasedModel<E> model, Set<ModelAttachmentsType.Location> hidden) {
        for (ModelAttachmentsType.Location location : hidden) {
            switch (location) {
                case HEAD: {
                    model.head.visible = false;
                    break;
                }
                case BODY: {
                    model.body.visible = false;
                    break;
                }
                case LEFT_ARM: {
                    model.leftArm.visible = false;
                    break;
                }
                case RIGHT_ARM: {
                    model.rightArm.visible = false;
                    break;
                }
                case LEGS: {
                    model.leftLeg.visible = false;
                    model.rightLeg.visible = false;
                    break;
                }
                case LEFT_LEG: {
                    model.leftLeg.visible = false;
                    break;
                }
                case RIGHT_LEG: {
                    model.rightLeg.visible = false;
                }
            }
        }
    }

    private <E extends NPCEntity> void translateToPart(HumanoidBasedModel<E> model, ModelAttachmentsType.Location location, class_4587 poseStack) {
        switch (location) {
            case HEAD: {
                model.head.translateAndRotateWithParents(poseStack);
                break;
            }
            case BODY: {
                model.body.translateAndRotateWithParents(poseStack);
                break;
            }
            case LEFT_ARM: {
                model.leftArm.translateAndRotateWithParents(poseStack);
                break;
            }
            case RIGHT_ARM: {
                model.rightArm.translateAndRotateWithParents(poseStack);
                break;
            }
            case LEGS: {
                if (model.legBase != null) {
                    model.legBase.translateAndRotateWithParents(poseStack);
                    break;
                }
                double dx = model.leftLeg.x - model.rightLeg.x;
                double dy = model.leftLeg.y - model.rightLeg.y;
                double dz = model.leftLeg.z - model.rightLeg.z;
                poseStack.method_22904(dx, dy, dz);
                model.rightLeg.translateAndRotateWithParents(poseStack);
                break;
            }
            case LEFT_LEG: {
                model.leftLeg.translateAndRotateWithParents(poseStack);
                break;
            }
            case RIGHT_LEG: {
                model.rightLeg.translateAndRotateWithParents(poseStack);
            }
        }
    }
}

