/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.npc;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.model.HumanoidBasedModel;
import io.github.flemmli97.runecraftory.client.model.HumanoidModelLocations;
import io.github.flemmli97.runecraftory.client.render.npc.NPCArmorLayer;
import io.github.flemmli97.runecraftory.client.render.npc.NPCFaceLayer;
import io.github.flemmli97.runecraftory.client.render.npc.NPCFeatureRenderLayer;
import io.github.flemmli97.runecraftory.client.render.npc.NPCFeatureRenderers;
import io.github.flemmli97.runecraftory.client.render.npc.NPCModelHolder;
import io.github.flemmli97.runecraftory.client.render.npc.NPCTextureLayer;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.features.BlushFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.FaceFeaturesType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSettingType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ModelFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.entities.npc.features.OutfitFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.SimpleHatFeatureType;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import io.github.flemmli97.tenshilib.client.render.layer.ItemLayer;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1921;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_7833;
import net.minecraft.class_8685;
import net.minecraft.class_927;
import org.jetbrains.annotations.Nullable;

public class NPCRender<T extends NPCEntity>
extends class_927<T, HumanoidBasedModel<T>> {
    private static final Map<String, PlayerSkinData> PLAYER_SKIN_TEXTURE_LOCATIONS = new HashMap<String, PlayerSkinData>();
    private static final Map<String, class_2960> TEXTURE_LAYERS_LOCATIONS = new HashMap<String, class_2960>();
    public static final class_2960 EMPTY = RuneCraftory.modRes("textures/entity/npc/empty.png");
    public final NPCArmorLayer<T> armorLayer;
    public final List<NPCTextureLayer<T>> textureLayers = new ArrayList<NPCTextureLayer<T>>();
    private final class_572<T> internalHumanoid;
    private final Map<Pair<class_2960, class_2960>, NPCModelHolder> models = new HashMap<Pair<class_2960, class_2960>, NPCModelHolder>();
    private NPCModelHolder current;

    public NPCRender(class_5617.class_5618 ctx) {
        super(ctx, new HumanoidBasedModel(), 0.5f);
        this.internalHumanoid = new class_572(ctx.method_32167(class_5602.field_27577));
        this.armorLayer = new NPCArmorLayer(this, new class_3883<T, class_572<T>>(){

            public class_572<T> getModel() {
                return NPCRender.this.internalHumanoid;
            }

            public class_2960 getTextureLocation(T entity) {
                return NPCRender.this.getTextureLocation(entity);
            }
        }, ctx);
        this.method_4046(this.armorLayer);
        this.method_4046((class_3887)new ItemLayer((class_3883)this, ctx.method_43338()));
        this.current = this.getModelHolder(HumanoidModelLocations.DEFAULT_LOCATION);
        this.getModelHolder(HumanoidModelLocations.DEFAULT_LOCATION_SLIM);
        for (NPCTextureLayer.LayerType layerType : NPCTextureLayer.LayerType.values()) {
            if (layerType.modelType == null) continue;
            if (layerType == NPCTextureLayer.LayerType.IRIS_LAYER) {
                this.textureLayers.add(new NPCFaceLayer(this));
                continue;
            }
            this.textureLayers.add(new NPCTextureLayer(this, layerType));
        }
        this.textureLayers.forEach(x$0 -> this.method_4046((class_3887)x$0));
        this.method_4046(new NPCFeatureRenderLayer(this));
    }

    public static boolean isSlim(NPCEntity npc) {
        NPCLook look = npc.getLook().value();
        if (look == NPCLook.DEFAULT.value()) {
            return class_1068.method_4648((UUID)npc.method_5667()).comp_1629() == class_8685.class_7920.field_41122;
        }
        String skin = look.playerSkin();
        if (skin != null) {
            class_8685.class_7920 skinMeta = PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkinData(skin)).getSkinMeta();
            return skinMeta == class_8685.class_7920.field_41122;
        }
        return npc.lookFeatures.contains((NPCFeatureType)RuneCraftoryNPCLooks.SLIM.get());
    }

    public static class_2960 getTextureFromLook(NPCEntity npc, NPCTextureLayer.LayerType type, @Nullable String subType) {
        NPCLook look = npc.getLook().value();
        if (type == NPCTextureLayer.LayerType.SKIN_LAYER) {
            if (look == NPCLook.DEFAULT.value()) {
                return class_1068.method_4648((UUID)npc.method_5667()).comp_1626();
            }
            String skin = look.playerSkin();
            if (skin != null) {
                return PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkinData(skin)).getLocation();
            }
        } else if (look.playerSkin() != null || look == NPCLook.DEFAULT.value()) {
            return EMPTY;
        }
        boolean slim = NPCRender.isSlim(npc);
        if (type == NPCTextureLayer.LayerType.HAT_LAYER && npc.method_6084(class_1304.field_6169)) {
            return EMPTY;
        }
        return NPCRender.getTextureFromLook(npc.lookFeatures, slim, type, subType);
    }

    public static class_2960 getTextureFromLook(NPCFeatureContainer features, boolean slim, NPCTextureLayer.LayerType type, @Nullable String subType) {
        class_2960 texture;
        ModelFeatureType.ModelFeature modelFeature = (ModelFeatureType.ModelFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.MODEL.get());
        String prefix = null;
        if (modelFeature != null) {
            prefix = modelFeature.model().map(ModelFeatureType.ModelData::layerPrefix).orElse(null);
            texture = modelFeature.model().flatMap(ModelFeatureType.ModelData::texture).orElse(null);
            if (texture != null) {
                if (type != NPCTextureLayer.LayerType.SKIN_LAYER) {
                    return EMPTY;
                }
                return TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(texture.toString(), res -> texture.method_45134(s -> "textures/" + s + ".png"));
            }
        }
        texture = switch (type) {
            default -> throw new MatchException(null, null);
            case NPCTextureLayer.LayerType.SKIN_LAYER -> {
                Record feat = (IndexedColorSettingType.IndexedColorFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.SKIN.get());
                int num = 0;
                if (feat != null) {
                    num = ((IndexedColorSettingType.IndexedColorFeature)feat).index();
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/skin/", prefix, slim ? "slim" : "", num);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.IRIS_LAYER -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).iris().index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.IRIS);
                    }
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/eye/iris_", prefix, num, subType);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.SCLERA_LAYER -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).sclera().index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.SCLERA);
                    }
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/eye/sclera_", prefix, num, subType);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.EYEBROWS_LAYER -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                int num = 0;
                if (feat != null) {
                    num = ((FaceFeaturesType.FaceFeatures)feat).eyebrow().index();
                    if (subType != null) {
                        subType = ((FaceFeaturesType.FaceFeatures)feat).expressionTexture(features, subType, FaceFeaturesType.ExpressionType.EYEBROWS);
                    }
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/eye/eyebrows_", prefix, num, subType);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.BLUSH_LAYER -> {
                Record feat = (BlushFeatureType.BlushFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.BLUSH.get());
                if (feat == null || !((BlushFeatureType.BlushFeature)feat).blush()) {
                    yield null;
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/misc/blush", prefix);
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.OUTFIT_LAYER -> {
                Record feat = (OutfitFeatureType.OutfitFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.OUTFIT.get());
                String location = String.format("textures/entity/npc/outfit/generic%s_0.png", slim ? "_slim" : "");
                if (feat != null) {
                    location = NPCRender.formatTextureTemplate("textures/entity/npc/outfit/", ((OutfitFeatureType.OutfitFeature)feat).outfit(), slim ? "slim" : "", ((OutfitFeatureType.OutfitFeature)feat).index());
                }
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.HAIR_LAYER -> {
                Record feat = (HairFeatureType.HairFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.HAIR.get());
                if (feat == null) {
                    yield null;
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/hair/", prefix, ((HairFeatureType.HairFeature)feat).hair(), ((HairFeatureType.HairFeature)feat).index());
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
            case NPCTextureLayer.LayerType.HAT_LAYER -> {
                Record feat = (SimpleHatFeatureType.SimpleHatFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.HAT.get());
                if (feat == null || ((SimpleHatFeatureType.SimpleHatFeature)feat).hat().isEmpty()) {
                    yield null;
                }
                String location = NPCRender.formatTextureTemplate("textures/entity/npc/misc/", ((SimpleHatFeatureType.SimpleHatFeature)feat).hat());
                yield TEXTURE_LAYERS_LOCATIONS.computeIfAbsent(location, RuneCraftory::modRes);
            }
        };
        return texture == null ? EMPTY : texture;
    }

    private static String formatTextureTemplate(String format, Object ... args) {
        StringBuilder formatBuilder = new StringBuilder(format);
        ArrayList<CallSite> formatArgs = new ArrayList<CallSite>();
        int idx = 0;
        for (Object arg : args) {
            String argRep;
            if (arg == null || (argRep = arg.toString()).isEmpty()) continue;
            formatBuilder.append("%s");
            formatArgs.add((CallSite)((Object)((idx != 0 ? "_" : "") + argRep)));
            ++idx;
        }
        return String.format(formatBuilder.append(".png").toString(), formatArgs.toArray());
    }

    public static boolean renderForTooltip(class_332 graphics, int x, int y, @Nullable String skin, List<Pair<Integer, class_2960>> textures) {
        if (skin == null && textures == null) {
            return false;
        }
        int sizeX = 16;
        int sizeY = 16;
        if (skin != null) {
            class_2960 res = PLAYER_SKIN_TEXTURE_LOCATIONS.computeIfAbsent(skin, s -> new PlayerSkinData(skin)).getLocation();
            graphics.method_25293(res, x, y, sizeX, sizeY, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.enableBlend();
            graphics.method_25293(res, x, y, sizeX, sizeY, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
        } else {
            for (Pair<Integer, class_2960> layer : textures) {
                int color = (Integer)layer.getFirst();
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
                graphics.method_25293((class_2960)layer.getSecond(), x, y, sizeX, sizeY, 8.0f, 8.0f, 8, 8, 64, 64);
                RenderSystem.enableBlend();
                graphics.method_25293((class_2960)layer.getSecond(), x, y, sizeX, sizeY, 40.0f, 8.0f, 8, 8, 64, 64);
                RenderSystem.disableBlend();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    protected boolean shouldShowName(T entity) {
        return false;
    }

    public void render(T entity, float entityYaw, float partialTicks, class_4587 stack, class_4597 buffer, int packedLight) {
        boolean slim = NPCRender.isSlim(entity);
        this.updateModelFromEntity(entity, slim);
        ((HumanoidBasedModel)this.method_4038()).setDelegate(this.internalHumanoid);
        this.armorLayer.setSlim(slim);
        this.setModelProperties((NPCEntity)entity);
        for (NPCFeature feature : ((NPCEntity)entity).lookFeatures) {
            NPCFeatureRenderers.get(feature).onSetup(feature, this, entity, stack);
        }
        super.method_4054(entity, entityYaw, partialTicks, stack, buffer, packedLight);
    }

    protected void updateModelFromEntity(T entity, boolean slim) {
        this.current = this.getModelHolder(this.getModelLocation(entity, slim));
        this.field_4737 = this.current.get(NPCTextureLayer.ModelType.SKIN_LAYER);
    }

    protected Pair<class_2960, class_2960> getModelLocation(T entity, boolean slim) {
        ModelFeatureType.ModelFeature modelFeature = (ModelFeatureType.ModelFeature)((NPCEntity)entity).lookFeatures.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.MODEL.get());
        class_2960 model = slim ? HumanoidModelLocations.DEFAULT_LOCATION_SLIM : HumanoidModelLocations.DEFAULT_LOCATION;
        class_2960 animation = null;
        if (modelFeature != null) {
            ModelFeatureType.ModelData modelData = modelFeature.model().orElse(null);
            if (modelData != null) {
                model = modelData.model();
            }
            if (modelFeature.animation().isPresent()) {
                animation = modelFeature.animation().get();
            }
        }
        return Pair.of((Object)model, animation);
    }

    private NPCModelHolder getModelHolder(class_2960 model) {
        return this.getModelHolder((Pair<class_2960, class_2960>)Pair.of((Object)model, null));
    }

    protected NPCModelHolder getModelHolder(Pair<class_2960, class_2960> location) {
        return this.models.computeIfAbsent(location, key -> new NPCModelHolder(location));
    }

    protected NPCModelHolder getCurrent() {
        return this.current;
    }

    private void setModelProperties(NPCEntity npc) {
        HumanoidBasedModel currentModel = (HumanoidBasedModel)this.method_4038();
        currentModel.setAllVisible(true);
        currentModel.crouching = npc.method_18276();
        class_572.class_573 main = NPCRender.getArmPose(npc, class_1268.field_5808);
        class_572.class_573 off = NPCRender.getArmPose(npc, class_1268.field_5810);
        if (main.method_30156()) {
            class_572.class_573 class_5732 = off = npc.method_6079().method_7960() ? class_572.class_573.field_3409 : class_572.class_573.field_3410;
        }
        if (npc.method_6068() == class_1306.field_6183) {
            currentModel.rightArmPose = main;
            currentModel.leftArmPose = off;
        } else {
            currentModel.rightArmPose = off;
            currentModel.leftArmPose = main;
        }
    }

    private static class_572.class_573 getArmPose(NPCEntity npc, class_1268 hand) {
        class_1799 itemStack = npc.method_5998(hand);
        if (itemStack.method_7960()) {
            return class_572.class_573.field_3409;
        }
        if (npc.method_6058() == hand && npc.method_6014() > 0) {
            class_1839 useAnim = itemStack.method_7976();
            if (useAnim == class_1839.field_8949) {
                return class_572.class_573.field_3406;
            }
            if (useAnim == class_1839.field_8953) {
                return class_572.class_573.field_3403;
            }
            if (useAnim == class_1839.field_8951) {
                return class_572.class_573.field_3407;
            }
            if (useAnim == class_1839.field_8947 && hand == npc.method_6058()) {
                return class_572.class_573.field_3405;
            }
            if (useAnim == class_1839.field_27079) {
                return class_572.class_573.field_27434;
            }
        } else if (!npc.field_6252 && itemStack.method_31574(class_1802.field_8399) && class_1764.method_7781((class_1799)itemStack)) {
            return class_572.class_573.field_3408;
        }
        return class_572.class_573.field_3410;
    }

    public class_2960 getTextureLocation(T entity) {
        return NPCRender.getTextureFromLook(entity, NPCTextureLayer.LayerType.SKIN_LAYER, null);
    }

    protected void setupRotations(T entity, class_4587 stack, float bob, float yBodyRot, float partialTick, float scale) {
        super.method_4058(entity, stack, bob, yBodyRot, partialTick, scale);
        if (((NPCEntity)entity).getPlayDeathTick() > 0) {
            float f;
            float partial = partialTick - 1.0f;
            float f2 = ((float)((NPCEntity)entity).getPlayDeathTick() + (((NPCEntity)entity).playDeath() ? partial : -partial)) / 20.0f * 1.6f;
            f2 = class_3532.method_15355((float)f2);
            if (f > 1.0f) {
                f2 = 1.0f;
            }
            stack.method_22904(0.0, (double)f2 * 0.1, (double)(-f2 * entity.method_17682()) * 0.5);
            stack.method_22907(class_7833.field_40714.rotationDegrees(f2 * this.method_4039((class_1309)entity)));
        }
        for (NPCFeature feature : ((NPCEntity)entity).lookFeatures) {
            NPCFeatureRenderers.get(feature).transformStack(feature, this, entity, stack, partialTick);
        }
    }

    protected void scale(T livingEntity, class_4587 matrixStack, float partialTickTime) {
        matrixStack.method_22905(0.9375f, 0.9375f, 0.9375f);
    }

    @Nullable
    protected class_1921 getRenderType(T entity, boolean invis, boolean translucent, boolean glowing) {
        return null;
    }

    static class PlayerSkinData {
        private GameProfile gameProfile;
        private class_2960 location = class_1068.method_4649();
        private class_8685.class_7920 skinMeta = class_8685.class_7920.field_41122;
        private boolean pendingTextures;

        public PlayerSkinData(String name) {
            class_2631.method_52580((String)name).thenAccept(prof -> prof.ifPresent(p -> {
                this.gameProfile = p;
            }));
        }

        public class_2960 getLocation() {
            this.registerTextures();
            return this.location;
        }

        public class_8685.class_7920 getSkinMeta() {
            this.registerTextures();
            return this.skinMeta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void registerTextures() {
            PlayerSkinData playerSkinData = this;
            synchronized (playerSkinData) {
                if (!this.pendingTextures && this.gameProfile != null) {
                    this.pendingTextures = true;
                    class_310.method_1551().method_1582().method_52863(this.gameProfile).thenAccept(skin -> {
                        this.location = skin.comp_1626();
                        this.skinMeta = skin.comp_1629();
                    });
                }
            }
        }
    }
}

