/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.npc;

import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.model.HumanoidBasedModel;
import io.github.flemmli97.runecraftory.client.render.npc.NPCRender;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.features.BlushFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.FaceFeaturesType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSettingType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ModelFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;

public class NPCTextureLayer<T extends NPCEntity>
extends class_3887<T, HumanoidBasedModel<T>> {
    private final NPCRender<T> renderer;
    protected LayerType layer;

    public NPCTextureLayer(NPCRender<T> renderer, LayerType layer) {
        super(renderer);
        this.renderer = renderer;
        this.layer = layer;
    }

    public static int setColor(NPCEntity entity, LayerType layer) {
        if (layer == LayerType.SKIN_LAYER) {
            if (entity.getLook().value().playerSkin() != null) {
                return -1;
            }
            ModelFeatureType.ModelFeature modelFeature = (ModelFeatureType.ModelFeature)entity.lookFeatures.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.MODEL.get());
            if (modelFeature != null && modelFeature.model().flatMap(ModelFeatureType.ModelData::texture).orElse(null) != null) {
                return -1;
            }
        }
        return NPCTextureLayer.setColor(entity.lookFeatures, layer);
    }

    public static int setColor(NPCFeatureContainer features, LayerType layer) {
        int color = switch (layer.ordinal()) {
            case 0 -> {
                Record feat = (IndexedColorSettingType.IndexedColorFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.SKIN.get());
                if (feat == null) {
                    yield 14008231;
                }
                yield ((IndexedColorSettingType.IndexedColorFeature)feat).color();
            }
            case 2 -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).iris() == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).iris().color();
            }
            case 3 -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).sclera() == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).sclera().color();
            }
            case 4 -> {
                Record feat = (FaceFeaturesType.FaceFeatures)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
                if (feat == null || ((FaceFeaturesType.FaceFeatures)feat).eyebrow() == null) {
                    yield 0;
                }
                yield ((FaceFeaturesType.FaceFeatures)feat).eyebrow().color();
            }
            case 5 -> {
                Record feat = (BlushFeatureType.BlushFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.BLUSH.get());
                if (feat == null) {
                    yield 0xFFFFFF;
                }
                yield ((BlushFeatureType.BlushFeature)feat).color();
            }
            case 6 -> {
                Record feat = (HairFeatureType.HairFeature)features.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.HAIR.get());
                if (feat == null) {
                    yield 0xFFFFFF;
                }
                yield ((HairFeatureType.HairFeature)feat).color();
            }
            default -> 0xFFFFFF;
        };
        int a = 255;
        if (layer == LayerType.BLUSH_LAYER) {
            a = 88;
        }
        return a << 24 | color;
    }

    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, T npc, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        HumanoidBasedModel<T> layerModel = this.getModel();
        this.setup(layerModel);
        poseStack.method_22903();
        this.actualRender(poseStack, buffer, packedLight, npc, layerModel);
        poseStack.method_22909();
    }

    protected HumanoidBasedModel<T> getModel() {
        return this.renderer.getCurrent().get(this.layer.modelType);
    }

    protected void setup(HumanoidBasedModel<T> layerModel) {
        ((HumanoidBasedModel)this.method_17165()).method_17081(layerModel);
        this.setPartVisibility(layerModel);
    }

    protected void actualRender(class_4587 poseStack, class_4597 buffer, int packedLight, T npc, HumanoidBasedModel<T> layerModel) {
        boolean bl3;
        boolean bl2;
        class_310 mc = class_310.method_1551();
        boolean bl = !npc.method_5767();
        class_1921 renderType = this.getRenderType(npc, layerModel, bl, bl2 = !bl && !npc.method_5756((class_1657)mc.field_1724), bl3 = mc.method_27022(npc));
        if (renderType != null) {
            class_4588 vertexConsumer = buffer.getBuffer(renderType);
            int m = class_922.method_23622(npc, (float)0.0f);
            int color = this.setColor(npc);
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            layerModel.method_2828(poseStack, vertexConsumer, packedLight, m, class_5253.class_5254.method_59554((float)(a * (bl2 ? 0.15f : 1.0f)), (float)r, (float)g, (float)b));
        }
    }

    @Nullable
    protected class_1921 getRenderType(T entity, HumanoidBasedModel<T> model, boolean bodyVisible, boolean translucent, boolean glowing) {
        class_2960 resourceLocation;
        if (((NPCEntity)entity).getPlayDeathTick() > 0 && !((NPCEntity)entity).playDeath()) {
            if (((NPCEntity)entity).getPlayDeathTick() > 8 && ((NPCEntity)entity).getPlayDeathTick() % 2 == 0) {
                return null;
            }
            if (((NPCEntity)entity).getPlayDeathTick() % 3 == 0) {
                return null;
            }
        }
        if ((resourceLocation = this.getTexture(entity)).equals((Object)NPCRender.EMPTY)) {
            return null;
        }
        if (translucent) {
            return class_1921.method_29379((class_2960)resourceLocation);
        }
        if (bodyVisible) {
            return model.method_23500(resourceLocation);
        }
        if (glowing) {
            return class_1921.method_23287((class_2960)resourceLocation);
        }
        return null;
    }

    protected int setColor(T entity) {
        return NPCTextureLayer.setColor(entity, this.layer);
    }

    protected class_2960 getTexture(T entity) {
        return NPCRender.getTextureFromLook(entity, this.layer, null);
    }

    protected void setPartVisibility(HumanoidBasedModel<T> model) {
        if (this.layer == LayerType.SKIN_LAYER) {
            return;
        }
        model.setAllVisible(false);
        model.head.visible = ((HumanoidBasedModel)this.renderer.method_4038()).head.visible;
        switch (this.layer.ordinal()) {
            case 1: {
                model.copyVisibilityFrom((HumanoidBasedModel)this.renderer.method_4038());
                break;
            }
            case 6: {
                model.body.visible = ((HumanoidBasedModel)this.renderer.method_4038()).body.visible;
                model.rightArm.visible = ((HumanoidBasedModel)this.renderer.method_4038()).rightArm.visible;
                model.leftArm.visible = ((HumanoidBasedModel)this.renderer.method_4038()).leftArm.visible;
            }
        }
    }

    public static enum LayerType {
        SKIN_LAYER(ModelType.SKIN_LAYER),
        OUTFIT_LAYER(ModelType.OUTFIT_LAYER),
        IRIS_LAYER(ModelType.FACE_LAYER),
        SCLERA_LAYER(null),
        EYEBROWS_LAYER(null),
        BLUSH_LAYER(ModelType.BLUSH_LAYER),
        HAIR_LAYER(ModelType.HAIR_LAYER),
        HAT_LAYER(ModelType.HAT_LAYER);

        public final ModelType modelType;

        private LayerType(ModelType modelType) {
            this.modelType = modelType;
        }
    }

    public static enum ModelType {
        SKIN_LAYER(0.0f),
        OUTFIT_LAYER(0.005f),
        FACE_LAYER(0.006f),
        BLUSH_LAYER(0.009f),
        HAIR_LAYER(0.5f),
        HAT_LAYER(0.8f);

        public final float expand;

        private ModelType(float expand) {
            this.expand = expand;
        }
    }
}

