/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_5699;

public class ShippingTrigger
extends class_4558<TriggerInstance> {
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, PlayerData data, class_1799 stack) {
        this.method_22510(player, inst -> inst.matches(data, stack));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_2073> predicate;
        private final int amount;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2073.field_45754.optionalFieldOf("predicate").forGetter(TriggerInstance::predicate), (App)class_5699.field_33442.fieldOf("amount").forGetter(TriggerInstance::amount)).apply((Applicative)inst, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_2073> predicate, int amount) {
            this.player = player;
            this.predicate = predicate;
            this.amount = amount;
        }

        public static class_175<TriggerInstance> shipAny(int amount) {
            return ((ShippingTrigger)((Object)RuneCraftoryCriteria.SHIPPING_TRIGGER.get())).method_53699((class_184)new TriggerInstance(Optional.empty(), Optional.empty(), amount));
        }

        public static class_175<TriggerInstance> shipSpecific(class_2073.class_2074 item, int amount) {
            return ((ShippingTrigger)((Object)RuneCraftoryCriteria.SHIPPING_TRIGGER.get())).method_53699((class_184)new TriggerInstance(Optional.empty(), Optional.of(item.method_8976()), amount));
        }

        public boolean matches(PlayerData data, class_1799 stack) {
            if (this.predicate.isPresent()) {
                if (!this.predicate.get().method_8970(stack)) {
                    return false;
                }
                PlayerData.ShippedItemData shipped = data.shippedItemData(stack);
                return shipped != null && shipped.amount() >= this.amount;
            }
            return data.getShippedTypesAmount() >= this.amount;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;predicate;amount", "player", "predicate", "amount"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;predicate;amount", "player", "predicate", "amount"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;predicate;amount", "player", "predicate", "amount"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_2073> predicate() {
            return this.predicate;
        }

        public int amount() {
            return this.amount;
        }
    }
}

